/*
 * Decompiled with CFR 0.152.
 */
package org.openregistry.core.web.resources;

import com.sun.jersey.api.NotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.openregistry.core.domain.Identifier;
import org.openregistry.core.domain.Person;
import org.openregistry.core.domain.sor.ReconciliationCriteria;
import org.openregistry.core.domain.sor.SorPersonAlreadyExistsException;
import org.openregistry.core.repository.ReferenceRepository;
import org.openregistry.core.service.PersonService;
import org.openregistry.core.web.resources.PeopleResourceUtils;
import org.openregistry.core.web.resources.representations.ErrorsResponseRepresentation;
import org.openregistry.core.web.resources.representations.PersonRequestRepresentation;
import org.openregistry.core.web.resources.representations.PersonResponseRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;

@Named
@Singleton
@Path(value="/people")
public final class PeopleResource {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PersonService personService;
    private final ReferenceRepository referenceRepository;
    @Resource(name="reconciliationCriteriaFactory")
    private ObjectFactory<ReconciliationCriteria> reconciliationCriteriaObjectFactory;

    @Inject
    public PeopleResource(PersonService personService, ReferenceRepository referenceRepository) {
        this.personService = personService;
        this.referenceRepository = referenceRepository;
    }

    @GET
    @Path(value="{personIdType}/{personId}")
    @Produces(value={"application/xml", "application/json"})
    public PersonResponseRepresentation showPerson(@PathParam(value="personId") String personId, @PathParam(value="personIdType") String personIdType) {
        Person person = this.findPersonOrThrowNotFoundException(personIdType, personId);
        this.logger.info("Person is found. Building a suitable representation...");
        return new PersonResponseRepresentation(this.buildPersonIdentifierRepresentations(person.getIdentifiers()));
    }

    @POST
    @Path(value="{personIdType}/{personId}")
    @Consumes(value={"application/xml"})
    public Response linkSorPersonWithCalculatedPerson(@PathParam(value="personId") String personId, @PathParam(value="personIdType") String personIdType, PersonRequestRepresentation personRequestRepresentation) {
        Person person = this.findPersonOrThrowNotFoundException(personIdType, personId);
        ReconciliationCriteria reconciliationCriteria = PeopleResourceUtils.buildReconciliationCriteriaFrom((PersonRequestRepresentation)personRequestRepresentation, (ObjectFactory)this.reconciliationCriteriaObjectFactory, (ReferenceRepository)this.referenceRepository);
        this.logger.info("Trying to link incoming SOR person with calculated person...");
        try {
            this.personService.addPersonAndLink(reconciliationCriteria, person);
        }
        catch (SorPersonAlreadyExistsException ex) {
            return Response.status((int)409).entity((Object)new ErrorsResponseRepresentation(Arrays.asList(ex.getMessage()))).type("application/xml").build();
        }
        catch (IllegalStateException ex) {
            return Response.status((int)409).entity((Object)new ErrorsResponseRepresentation(Arrays.asList(ex.getMessage()))).type("application/xml").build();
        }
        return null;
    }

    private List<PersonResponseRepresentation.PersonIdentifierRepresentation> buildPersonIdentifierRepresentations(Set<? extends Identifier> identifiers) {
        ArrayList<PersonResponseRepresentation.PersonIdentifierRepresentation> idsRep = new ArrayList<PersonResponseRepresentation.PersonIdentifierRepresentation>();
        for (Identifier identifier : identifiers) {
            idsRep.add(new PersonResponseRepresentation.PersonIdentifierRepresentation(identifier.getType().getName(), identifier.getValue()));
        }
        if (idsRep.isEmpty()) {
            throw new IllegalStateException("Person identifiers cannot be empty");
        }
        return idsRep;
    }

    private Person findPersonOrThrowNotFoundException(String personIdType, String personId) {
        this.logger.info(String.format("Searching for a person with  {personIdType:%s, personId:%s} ...", personIdType, personId));
        Person person = this.personService.findPersonByIdentifier(personIdType, personId);
        if (person == null) {
            this.logger.info("Person is not found.");
            throw new NotFoundException(String.format("The person resource identified by /people/%s/%s URI does not exist", personIdType, personId));
        }
        return person;
    }
}

