/*
 * Decompiled with CFR 0.152.
 */
package org.openregistry.core.web.resources;

import com.sun.jersey.api.NotFoundException;
import java.util.Arrays;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.openregistry.core.domain.Type;
import org.openregistry.core.domain.sor.SorPerson;
import org.openregistry.core.repository.ReferenceRepository;
import org.openregistry.core.service.EmailService;
import org.openregistry.core.service.PersonService;
import org.openregistry.core.service.ServiceExecutionResult;
import org.openregistry.core.utils.ValidationUtils;
import org.openregistry.core.web.resources.EmailResource;
import org.openregistry.core.web.resources.representations.ErrorsResponseRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
@Path(value="/email")
public class EmailResource {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PersonService personService;
    private final ReferenceRepository referenceRepository;
    private final EmailService emailService;

    @Inject
    public EmailResource(EmailService emailService, PersonService personService, ReferenceRepository referenceRepository) {
        this.personService = personService;
        this.referenceRepository = referenceRepository;
        this.emailService = emailService;
    }

    @GET
    @Produces(value={"text/plain"})
    public Response findEmail(@QueryParam(value="sor") String sor, @QueryParam(value="emailType") String emailType, @QueryParam(value="identifierType") String identifierType, @QueryParam(value="identifier") String identifier, @QueryParam(value="affiliation") String affiliation) {
        LocalData localData = this.extractProcessingDataFrom(emailType, identifierType, identifier, affiliation, sor);
        if (localData.response != null) {
            return localData.response;
        }
        String emailAddress = this.emailService.findEmailForSorPersonWithRoleIdentifiedByAffiliation(localData.sorPerson, localData.emailAddressType, localData.affiliationType);
        if (emailAddress == null) {
            return Response.noContent().build();
        }
        return Response.ok((Object)emailAddress).build();
    }

    @POST
    @Consumes(value={"text/plain"})
    public Response addOrUpdateEmail(String emailAddress, @QueryParam(value="sor") String sor, @QueryParam(value="emailType") String emailType, @QueryParam(value="identifierType") String identifierType, @QueryParam(value="identifier") String identifier, @QueryParam(value="affiliation") String affiliation) {
        LocalData localData = this.extractProcessingDataFrom(emailType, identifierType, identifier, affiliation, sor);
        if (localData.response != null) {
            return localData.response;
        }
        ServiceExecutionResult result = this.emailService.saveOrCreateEmailForSorPersonWithRoleIdentifiedByAffiliation(localData.sorPerson, emailAddress, localData.emailAddressType, localData.affiliationType);
        if (!result.succeeded()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorsResponseRepresentation(ValidationUtils.buildValidationErrorsResponseAsList((Set)result.getValidationErrors()))).type("application/xml").build();
        }
        if (result.getTargetObject() == null) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)new ErrorsResponseRepresentation(Arrays.asList("The provided email could not be processed due to internal state conflict for this person"))).type("application/xml").build();
        }
        return Response.ok((Object)"The provided email has been processed successfully.").build();
    }

    private Response validateRequiredRequestQueryParams(String emailType, String identifierType, String identifier, String affiliation, String sor) {
        if (emailType == null || identifierType == null || identifier == null || affiliation == null || sor == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorsResponseRepresentation(Arrays.asList("The request URI is malformed. Please see the documentation and construct the correct request URI."))).type("application/xml").build();
        }
        return null;
    }

    private LocalData extractProcessingDataFrom(String emailType, String identifierType, String identifier, String affiliation, String sor) {
        LocalData d = new LocalData(null);
        Response r = this.validateRequiredRequestQueryParams(emailType, identifierType, identifier, affiliation, sor);
        if (r != null) {
            d.response = r;
            return d;
        }
        Type validatedType = this.referenceRepository.findValidType(Type.DataTypes.ADDRESS, emailType);
        if (validatedType == null) {
            d.response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorsResponseRepresentation(Arrays.asList("The provided email type is invalid."))).type("application/xml").build();
            return d;
        }
        d.emailAddressType = validatedType;
        validatedType = this.referenceRepository.findValidType(Type.DataTypes.AFFILIATION, affiliation);
        if (validatedType == null) {
            d.response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorsResponseRepresentation(Arrays.asList("The provided affiliation type is invalid."))).type("application/xml").build();
            return d;
        }
        d.affiliationType = validatedType;
        SorPerson sorPerson = this.personService.findByIdentifierAndSource(identifierType, identifier, sor);
        if (sorPerson == null) {
            throw new NotFoundException("The person cannot be found in the registry or is not attached to the provided SOR");
        }
        d.sorPerson = sorPerson;
        return d;
    }
}

