/*
 * Decompiled with CFR 0.152.
 */
package org.openregistry.core.web;

import java.util.Set;
import javax.inject.Named;
import javax.validation.ConstraintViolation;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.validation.Errors;

@Named(value="springErrorValidationErrorConverter")
public final class SpringErrorValidationErrorConverter {
    public void convertValidationErrors(Set<ConstraintViolation> validationErrors, Errors errors) {
        for (ConstraintViolation violation : validationErrors) {
            errors.rejectValue(violation.getPropertyPath().toString(), violation.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName(), violation.getConstraintDescriptor().getAttributes().values().toArray(), violation.getMessage());
        }
    }

    public void convertValidationErrors(Set<ConstraintViolation> validationErrors, MessageContext messages) {
        for (ConstraintViolation violation : validationErrors) {
            messages.addMessage(new MessageBuilder().error().args(violation.getConstraintDescriptor().getAttributes().values().toArray()).source((Object)violation.getPropertyPath().toString()).code(violation.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName()).defaultText(violation.getMessage()).build());
        }
    }
}

