/*
 * Decompiled with CFR 0.152.
 */
package org.openregistry.core.web;

import java.util.Calendar;
import javax.inject.Inject;
import javax.inject.Named;
import org.openregistry.core.domain.Address;
import org.openregistry.core.domain.EmailAddress;
import org.openregistry.core.domain.Person;
import org.openregistry.core.domain.Phone;
import org.openregistry.core.domain.Type;
import org.openregistry.core.domain.sor.SorPerson;
import org.openregistry.core.domain.sor.SorRole;
import org.openregistry.core.repository.ReferenceRepository;
import org.openregistry.core.service.PersonService;
import org.openregistry.core.service.ServiceExecutionResult;
import org.openregistry.core.web.AbstractPersonServiceAction;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;

@Named(value="roleAction")
public final class RoleAction
extends AbstractPersonServiceAction {
    private final ReferenceRepository referenceRepository;

    @Inject
    public RoleAction(PersonService personService, ReferenceRepository referenceRepository) {
        super(personService);
        this.referenceRepository = referenceRepository;
    }

    protected SorRole addRole(SorPerson sorPerson, Type affiliationType) {
        SorRole sorRole = sorPerson.createRole(affiliationType);
        sorRole.setPersonStatus(this.referenceRepository.findType(Type.DataTypes.STATUS, (Enum)Type.PersonStatusTypes.ACTIVE));
        EmailAddress emailAddress = sorRole.createEmailAddress();
        sorRole.addEmailAddress(emailAddress);
        emailAddress.setAddressType(this.referenceRepository.findType(Type.DataTypes.ADDRESS, (Enum)Type.AddressTypes.CAMPUS));
        Phone phone = sorRole.createPhone();
        phone.setPhoneType(this.referenceRepository.findType(Type.DataTypes.PHONE, (Enum)Type.PhoneTypes.CELL));
        phone.setAddressType(this.referenceRepository.findType(Type.DataTypes.ADDRESS, (Enum)Type.AddressTypes.CAMPUS));
        sorRole.addPhone(phone);
        Address address = sorRole.createAddress();
        address.setType(this.referenceRepository.findType(Type.DataTypes.ADDRESS, (Enum)Type.AddressTypes.CAMPUS));
        sorRole.addAddress(address);
        sorRole.setSponsorType(this.referenceRepository.findType(Type.DataTypes.SPONSOR, (Enum)Type.SponsorTypes.PERSON));
        Calendar cal = Calendar.getInstance();
        sorRole.setStart(cal.getTime());
        cal.add(2, 6);
        sorRole.setEnd(cal.getTime());
        sorPerson.addRole(sorRole);
        return sorRole;
    }

    public boolean isRoleNewForPerson(SorPerson sorPerson, Type affiliationType, MessageContext context) {
        this.logger.info("IsRoleNewForPerson: code:" + affiliationType);
        Person person = this.getPersonService().findPersonById(sorPerson.getPersonId());
        if (person.pickOutRole(affiliationType) != null) {
            context.addMessage(new MessageBuilder().error().code("roleAlreadyExists").build());
            return false;
        }
        return true;
    }

    public boolean addSorRole(SorPerson sorPerson, SorRole sorRole, MessageContext context) {
        ServiceExecutionResult result = this.getPersonService().validateAndSaveRoleForSorPerson(sorPerson, sorRole);
        return this.convertAndReturnStatus(result, context, null);
    }

    public boolean updateSorRole(SorPerson sorPerson, SorRole role, MessageContext context) {
        ServiceExecutionResult result = this.getPersonService().updateSorRole(sorPerson, role);
        return this.convertAndReturnStatus(result, context, "roleUpdated");
    }

    public boolean expireRole(SorRole role, MessageContext context) {
        this.getPersonService().expireRole(role);
        return true;
    }

    public boolean renewRole(SorRole role, MessageContext context) {
        this.getPersonService().renewRole(role);
        return true;
    }
}

