/*
 * Decompiled with CFR 0.152.
 */
package org.openregistry.core.web;

import javax.annotation.Resource;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openregistry.core.domain.Type;
import org.openregistry.core.repository.ReferenceRepository;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public final class ReferenceRepositoryHandlerInterceptor
extends HandlerInterceptorAdapter {
    private final ReferenceRepository referenceRepository;
    @Resource
    private String preferredPersonIdentifierType;

    @Inject
    public ReferenceRepositoryHandlerInterceptor(ReferenceRepository referenceRepository) {
        this.referenceRepository = referenceRepository;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse httpServletResponse, Object o) throws Exception {
        request.setAttribute("countries", (Object)this.referenceRepository.getCountries());
        request.setAttribute("regions", (Object)this.referenceRepository.getRegions());
        request.setAttribute("campuses", (Object)this.referenceRepository.getCampuses());
        request.setAttribute("identifierTypes", (Object)this.referenceRepository.getIdentifierTypes());
        request.setAttribute("organizationalUnits", (Object)this.referenceRepository.getOrganizationalUnits());
        request.setAttribute("addressTypes", (Object)this.referenceRepository.getTypesBy(Type.DataTypes.ADDRESS));
        request.setAttribute("affiliationTypes", (Object)this.referenceRepository.getTypesBy(Type.DataTypes.AFFILIATION));
        request.setAttribute("campusTypes", (Object)this.referenceRepository.getTypesBy(Type.DataTypes.CAMPUS));
        request.setAttribute("nameTypes", (Object)this.referenceRepository.getTypesBy(Type.DataTypes.NAME));
        request.setAttribute("organizationalUnitTypes", (Object)this.referenceRepository.getTypesBy(Type.DataTypes.ORGANIZATIONAL_UNIT));
        request.setAttribute("personTypes", (Object)this.referenceRepository.getTypesBy(Type.DataTypes.PERSON));
        request.setAttribute("phoneTypes", (Object)this.referenceRepository.getTypesBy(Type.DataTypes.PHONE));
        request.setAttribute("sponsorTypes", (Object)this.referenceRepository.getTypesBy(Type.DataTypes.SPONSOR));
        request.setAttribute("statusTypes", (Object)this.referenceRepository.getTypesBy(Type.DataTypes.STATUS));
        request.setAttribute("terminationTypes", (Object)this.referenceRepository.getTypesBy(Type.DataTypes.TERMINATION));
        request.setAttribute("urlTypes", (Object)this.referenceRepository.getTypesBy(Type.DataTypes.URL));
        request.setAttribute("preferredPersonIdentifierType", (Object)this.preferredPersonIdentifierType);
        return true;
    }
}

