/*
 * Decompiled with CFR 0.152.
 */
package org.openregistry.core.web;

import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.openregistry.core.domain.Identifier;
import org.openregistry.core.domain.Person;
import org.openregistry.core.domain.sor.ReconciliationCriteria;
import org.openregistry.core.domain.sor.SorPerson;
import org.openregistry.core.domain.sor.SorPersonAlreadyExistsException;
import org.openregistry.core.service.PersonService;
import org.openregistry.core.service.ServiceExecutionResult;
import org.openregistry.core.service.reconciliation.ReconciliationException;
import org.openregistry.core.service.reconciliation.ReconciliationResult;
import org.openregistry.core.web.AbstractPersonServiceAction;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.message.MessageResolver;
import org.springframework.webflow.execution.RequestContext;

@Named(value="personSearchAction")
public final class PersonSearchAction
extends AbstractPersonServiceAction {
    @Resource
    private String preferredPersonIdentifierType;

    @Inject
    public PersonSearchAction(PersonService personService) {
        super(personService);
    }

    public String addSorPerson(ReconciliationCriteria reconciliationCriteria, RequestContext context) {
        ServiceExecutionResult result;
        block4: {
            reconciliationCriteria.getSorPerson().setSourceSor("or-webapp");
            result = this.getPersonService().addPerson(reconciliationCriteria);
            this.getSpringErrorValidationErrorConverter().convertValidationErrors(result.getValidationErrors(), context.getMessageContext());
            if (!context.getMessageContext().hasErrorMessages()) break block4;
            return "validationError";
        }
        try {
            context.getFlowScope().put("serviceExecutionResult", (Object)result);
            return "success";
        }
        catch (ReconciliationException e) {
            context.getFlowScope().put("reconciliationResult", (Object)e);
            return "reconciliation";
        }
        catch (SorPersonAlreadyExistsException sorPersonAlreadyExistsException) {
            return "error";
        }
    }

    public ServiceExecutionResult addSorPerson(ReconciliationCriteria reconciliationCriteria, MessageContext context) {
        reconciliationCriteria.getSorPerson().setSourceSor("or-webapp");
        ServiceExecutionResult result = this.getPersonService().forceAddPerson(reconciliationCriteria);
        this.getSpringErrorValidationErrorConverter().convertValidationErrors(result.getValidationErrors(), context);
        return result;
    }

    public void setConfirmationMessage(ServiceExecutionResult<Person> serviceExecutionResult, ReconciliationResult reconciliationResult, MessageContext context) {
        if (reconciliationResult != null && (reconciliationResult.getReconciliationType() == ReconciliationResult.ReconciliationType.EXACT || reconciliationResult.getReconciliationType() == ReconciliationResult.ReconciliationType.MAYBE)) {
            context.addMessage(new MessageBuilder().info().code("roleAdded").build());
            return;
        }
        Person person = (Person)serviceExecutionResult.getTargetObject();
        Identifier netId = (Identifier)person.getPrimaryIdentifiersByType().get(this.preferredPersonIdentifierType);
        if (person.getCurrentActivationKey() != null) {
            MessageResolver message = new MessageBuilder().info().code("personAddedFinalConfirm").arg((Object)netId.getValue()).arg((Object)person.getCurrentActivationKey().asString()).build();
            context.addMessage(message);
        } else {
            context.addMessage(new MessageBuilder().info().code("personAddedFinalConfirm").arg((Object)netId.getValue()).arg((Object)"TempKey").build());
        }
    }

    public boolean updateSorPerson(SorPerson sorPerson, MessageContext context) {
        ServiceExecutionResult result = this.getPersonService().updateSorPerson(sorPerson);
        return this.convertAndReturnStatus(result, context, null);
    }

    public boolean hasSorPersonRecord(Person p, String sourceSorId) {
        return this.getPersonService().findByPersonIdAndSorIdentifier(p.getId(), sourceSorId) != null;
    }

    public void setPreferredPersonIdentifierType(String preferredPersonIdentifierType) {
        this.preferredPersonIdentifierType = preferredPersonIdentifierType;
    }
}

