/*
 * Decompiled with CFR 0.152.
 */
package org.openregistry.core.web;

import java.util.List;
import javax.inject.Inject;
import org.openregistry.core.domain.Person;
import org.openregistry.core.domain.sor.SorPerson;
import org.openregistry.core.service.PersonService;
import org.openregistry.core.web.AbstractPersonServiceAction;
import org.springframework.stereotype.Component;

@Component
public final class PersonAction
extends AbstractPersonServiceAction {
    @Inject
    public PersonAction(PersonService personService) {
        super(personService);
    }

    public String moveSystemOfRecordPerson(Person fromPerson, Person toPerson, SorPerson sorPerson) {
        if (this.getPersonService().findByPersonIdAndSorIdentifier(toPerson.getId(), sorPerson.getSourceSor()) != null) {
            return "matchingSorFound";
        }
        if (this.getPersonService().moveSystemOfRecordPerson(fromPerson, toPerson, sorPerson)) {
            return "splitSuccess";
        }
        return "splitFailure";
    }

    public String moveSystemOfRecordPersonToNewPerson(Person fromPerson, SorPerson sorPerson) {
        if (this.getPersonService().moveSystemOfRecordPersonToNewPerson(fromPerson, sorPerson)) {
            return "splitSuccess";
        }
        return "splitFailure";
    }

    public String moveAllSystemOfRecordPerson(Person fromPerson, Person toPerson) {
        List sorPersonListFrom = this.getPersonService().getSorPersonsFor(fromPerson);
        for (SorPerson sorPersonFrom : sorPersonListFrom) {
            if (this.getPersonService().findByPersonIdAndSorIdentifier(toPerson.getId(), sorPersonFrom.getSourceSor()) == null) continue;
            this.logger.info("PersonAction: MoveAllSystemOfRecordPersons: matchingSorFound" + sorPersonFrom.getSourceSor());
            return "matchingSorFound";
        }
        this.logger.info("PersonAction: MoveAllSystemOfRecordPersons: Proceeding to do moveAllSystemOfRecord");
        if (this.getPersonService().moveAllSystemOfRecordPerson(fromPerson, toPerson)) {
            return "joinSuccess";
        }
        return "joinFailure";
    }
}

