/*
 * Decompiled with CFR 0.152.
 */
package org.openregistry.core.web;

import javax.inject.Inject;
import org.openregistry.core.domain.ActivationKey;
import org.openregistry.core.domain.Identifier;
import org.openregistry.core.domain.PersonNotFoundException;
import org.openregistry.core.service.ActivationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class IdentifierAction {
    private final ActivationService activationService;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Inject
    public IdentifierAction(ActivationService activationService) {
        this.activationService = activationService;
    }

    public boolean generateActivationKey(Identifier identifier, MessageContext context) {
        if (!StringUtils.hasText((String)identifier.getValue())) {
            context.addMessage(new MessageBuilder().error().code("identifierValueRequired").build());
            return false;
        }
        if (identifier.getType() == null || identifier.getType().getName() == null || identifier.getType().getName().trim().equals("")) {
            context.addMessage(new MessageBuilder().error().code("identifierTypeRequired").build());
            if (identifier.getType() == null) {
                this.logger.info("generateActivationKey: no type");
            }
            if (identifier.getType().getName() == null) {
                this.logger.info("generateActivationKey: no type value given");
            }
            return false;
        }
        try {
            ActivationKey key = this.activationService.generateActivationKey(identifier.getType().getName(), identifier.getValue());
            context.addMessage(new MessageBuilder().info().code("newActivationKey").arg((Object)key.asString()).build());
        }
        catch (PersonNotFoundException personNotFoundException) {
            context.addMessage(new MessageBuilder().error().code("personNotFound").build());
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            context.addMessage(new MessageBuilder().error().code("generateActivationKeyError").build());
            return false;
        }
        return true;
    }
}

