/*
 * Decompiled with CFR 0.152.
 */
package org.openregistry.core.web;

import javax.inject.Inject;
import org.openregistry.core.repository.PersonRepository;
import org.openregistry.core.repository.ReferenceRepository;
import org.openregistry.core.web.CampusConverter;
import org.openregistry.core.web.CountryConverter;
import org.openregistry.core.web.IdentifierTypeConverter;
import org.openregistry.core.web.RegionConverter;
import org.openregistry.core.web.SponsorConverter;
import org.openregistry.core.web.TypeConverter;
import org.openregistry.core.web.UrlConverter;
import org.openregistry.core.web.converters.TrimStringToStringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.binding.convert.converters.Converter;
import org.springframework.binding.convert.converters.StringToDate;
import org.springframework.binding.convert.service.DefaultConversionService;
import org.springframework.stereotype.Component;

@Component
public final class ApplicationConversionService
extends DefaultConversionService
implements InitializingBean {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ReferenceRepository referenceRepository;
    private final PersonRepository personRepository;
    private String defaultDateFormat = "yyyy-MM-dd";

    @Inject
    public ApplicationConversionService(PersonRepository personRepository, ReferenceRepository referenceRepository) {
        this.personRepository = personRepository;
        this.referenceRepository = referenceRepository;
    }

    protected void addDefaultConverters() {
        super.addDefaultConverters();
        StringToDate dateConverter = new StringToDate();
        dateConverter.setPattern("MM/dd/yyyy");
        this.addConverter("shortDate", (Converter)dateConverter);
        this.addConverter((Converter)new UrlConverter());
    }

    public void afterPropertiesSet() throws Exception {
        this.addConverter((Converter)new RegionConverter(this.referenceRepository));
        this.addConverter((Converter)new SponsorConverter(this.personRepository));
        this.addConverter((Converter)new CountryConverter(this.referenceRepository));
        this.addConverter((Converter)new CampusConverter(this.referenceRepository));
        this.addConverter((Converter)new TypeConverter(this.referenceRepository));
        this.addConverter((Converter)new IdentifierTypeConverter(this.referenceRepository));
        StringToDate dateConverter = new StringToDate();
        dateConverter.setPattern(this.defaultDateFormat);
        this.addConverter((Converter)dateConverter);
        this.addConverter((Converter)new TrimStringToStringConverter());
    }

    public void setDefaultDateFormat(String dateFormat) {
        this.defaultDateFormat = dateFormat;
    }
}

