/*
 * Decompiled with CFR 0.152.
 */
package org.openregistry.core.web;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.openregistry.core.domain.Name;
import org.openregistry.core.domain.Person;
import org.openregistry.core.service.MutableSearchCriteriaImpl;
import org.openregistry.core.service.PersonService;
import org.openregistry.core.service.SearchCriteria;
import org.openregistry.core.service.reconciliation.PersonMatch;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public final class AjaxController {
    @Inject
    private PersonService personService;

    @RequestMapping(value={"/nameSearch.json"}, method={RequestMethod.GET})
    public void nameSearch(@RequestParam(value="term") String term, Writer writer) throws IOException {
        MutableSearchCriteriaImpl searchCriteria = new MutableSearchCriteriaImpl();
        searchCriteria.setName(term);
        HashSet<String> names = new HashSet<String>();
        List personMatches = this.personService.searchForPersonBy((SearchCriteria)searchCriteria);
        for (PersonMatch personMatch : personMatches) {
            Person person = personMatch.getPerson();
            Name name = person.getOfficialName();
            names.add(String.valueOf(name.getGiven()) + " " + name.getFamily());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        boolean pastFirst = false;
        for (String name : names) {
            if (pastFirst) {
                stringBuilder.append(",");
            }
            pastFirst = true;
            stringBuilder.append("\"");
            stringBuilder.append(name);
            stringBuilder.append("\"");
        }
        stringBuilder.append("]");
        writer.write(stringBuilder.toString());
    }
}

