/*
 * Decompiled with CFR 0.152.
 */
package org.openregistry.core.web;

import org.openregistry.core.service.PersonService;
import org.openregistry.core.service.ServiceExecutionResult;
import org.openregistry.core.web.SpringErrorValidationErrorConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;

public abstract class AbstractPersonServiceAction {
    protected static final String STATIC_SOR_NAME = "or-webapp";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SpringErrorValidationErrorConverter converter = new SpringErrorValidationErrorConverter();
    private final PersonService personService;

    protected AbstractPersonServiceAction(PersonService personService) {
        this.personService = personService;
    }

    protected final PersonService getPersonService() {
        return this.personService;
    }

    protected final SpringErrorValidationErrorConverter getSpringErrorValidationErrorConverter() {
        return this.converter;
    }

    public final boolean convertAndReturnStatus(ServiceExecutionResult<?> serviceExecutionResult, MessageContext messageContext, String successMessageCode) {
        this.converter.convertValidationErrors(serviceExecutionResult.getValidationErrors(), messageContext);
        if (serviceExecutionResult.succeeded() && successMessageCode != null) {
            messageContext.addMessage(new MessageBuilder().info().code(successMessageCode).build());
        }
        return serviceExecutionResult.succeeded();
    }

    public void setConverter(SpringErrorValidationErrorConverter converter) {
        this.converter = converter;
    }
}

