/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter;
import org.jasig.cas.web.support.WebUtils;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public abstract class AbstractInMemoryThrottledSubmissionHandlerInterceptorAdapter
extends AbstractThrottledSubmissionHandlerInterceptorAdapter
implements Job {
    private static final double SUBMISSION_RATE_DIVIDEND = 1000.0;
    @Value(value="${cas.throttle.inmemory.cleaner.repeatinterval:5000}")
    private int refreshInterval;
    @Value(value="${cas.throttle.inmemory.cleaner.startdelay:5000}")
    private int startDelay;
    @Autowired
    @NotNull
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    @Qualifier(value="scheduler")
    private Scheduler scheduler;
    private final ConcurrentMap<String, Date> ipMap = new ConcurrentHashMap<String, Date>();

    @Override
    protected final boolean exceedsThreshold(HttpServletRequest request) {
        Date last = (Date)this.ipMap.get(this.constructKey(request));
        if (last == null) {
            return false;
        }
        return AbstractInMemoryThrottledSubmissionHandlerInterceptorAdapter.submissionRate(new Date(), last) > this.getThresholdRate();
    }

    @Override
    protected final void recordSubmissionFailure(HttpServletRequest request) {
        this.ipMap.put(this.constructKey(request), new Date());
    }

    protected abstract String constructKey(HttpServletRequest var1);

    public final void decrementCounts() {
        Set keys = this.ipMap.entrySet();
        this.logger.debug("Decrementing counts for throttler.  Starting key count: {}", (Object)keys.size());
        Date now = new Date();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!(AbstractInMemoryThrottledSubmissionHandlerInterceptorAdapter.submissionRate(now, (Date)entry.getValue()) < this.getThresholdRate())) continue;
            this.logger.trace("Removing entry for key {}", entry.getKey());
            iter.remove();
        }
        this.logger.debug("Done decrementing count for throttler.");
    }

    private static double submissionRate(Date a, Date b) {
        return 1000.0 / (double)(a.getTime() - b.getTime());
    }

    @PostConstruct
    public void scheduleThrottleJob() {
        try {
            if (this.shouldScheduleCleanerJob()) {
                this.logger.info("Preparing to schedule throttle job");
                JobDetail job = JobBuilder.newJob(((Object)((Object)this)).getClass()).withIdentity(((Object)((Object)this)).getClass().getSimpleName().concat(UUID.randomUUID().toString())).build();
                Trigger trigger = TriggerBuilder.newTrigger().withIdentity(((Object)((Object)this)).getClass().getSimpleName().concat(UUID.randomUUID().toString())).startAt(new Date(System.currentTimeMillis() + (long)this.startDelay)).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds((long)this.refreshInterval).repeatForever()).build();
                this.logger.debug("Scheduling {} job", (Object)((Object)((Object)this)).getClass().getName());
                this.scheduler.scheduleJob(job, trigger);
                this.logger.info("{} will clean tickets every {} seconds", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)TimeUnit.MILLISECONDS.toSeconds(this.refreshInterval));
            }
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    private boolean shouldScheduleCleanerJob() {
        if (this.startDelay > 0 && this.applicationContext.getParent() == null && this.scheduler != null && WebUtils.isCasServletInitializing((ApplicationContext)this.applicationContext)) {
            this.logger.debug("Found CAS servlet application context");
            String[] aliases = this.applicationContext.getAutowireCapableBeanFactory().getAliases("authenticationThrottle");
            this.logger.debug("{} is used as the active authentication throttle", (Object)((Object)((Object)this)).getClass().getSimpleName());
            return aliases.length > 0 && aliases[0].equals(this.getName());
        }
        return false;
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext((Object)((Object)this));
        try {
            this.logger.info("Beginning audit cleanup...");
            this.decrementCounts();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

