/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.AuthenticationManager;
import org.jasig.cas.authentication.AuthenticationTransaction;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter;
import org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapterTests;
import org.jasig.cas.web.support.InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter;
import org.jasig.inspektr.common.web.ClientInfo;
import org.jasig.inspektr.common.web.ClientInfoHolder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.test.MockRequestContext;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/core-context.xml", "classpath:/jpaTestApplicationContext.xml", "classpath:/inspektrThrottledSubmissionContext.xml"})
public class InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapterTests
extends AbstractThrottledSubmissionHandlerInterceptorAdapterTests {
    @Autowired
    @Qualifier(value="inspektrIpAddressUsernameThrottle")
    private InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter throttle;
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private DataSource dataSource;

    @Override
    @Before
    public void setUp() throws Exception {
        new JdbcTemplate(this.dataSource).execute("CREATE TABLE COM_AUDIT_TRAIL ( AUD_USER      VARCHAR(100)  NOT NULL, AUD_CLIENT_IP VARCHAR(15)    NOT NULL, AUD_SERVER_IP VARCHAR(15)    NOT NULL, AUD_RESOURCE  VARCHAR(100)  NOT NULL, AUD_ACTION    VARCHAR(100)  NOT NULL, APPLIC_CD     VARCHAR(5)    NOT NULL, AUD_DATE      TIMESTAMP      NOT NULL)");
    }

    @Override
    protected AbstractThrottledSubmissionHandlerInterceptorAdapter getThrottle() {
        return this.throttle;
    }

    @Override
    protected MockHttpServletResponse loginUnsuccessfully(String username, String fromAddress) throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setMethod("POST");
        request.setParameter("username", username);
        request.setRemoteAddr(fromAddress);
        MockRequestContext context = new MockRequestContext();
        context.setCurrentEvent(new Event((Object)"", "error"));
        request.setAttribute("flowRequestContext", (Object)context);
        ClientInfoHolder.setClientInfo((ClientInfo)new ClientInfo((HttpServletRequest)request));
        this.getThrottle().preHandle((HttpServletRequest)request, (HttpServletResponse)response, null);
        try {
            this.authenticationManager.authenticate(AuthenticationTransaction.wrap((Credential[])new Credential[]{this.badCredentials(username)}));
        }
        catch (AuthenticationException authenticationException) {
            this.getThrottle().postHandle((HttpServletRequest)request, (HttpServletResponse)response, null, null);
            return response;
        }
        Assert.fail((String)"Expected AbstractAuthenticationException");
        return null;
    }

    private UsernamePasswordCredential badCredentials(String username) {
        UsernamePasswordCredential credentials = new UsernamePasswordCredential();
        credentials.setUsername(username);
        credentials.setPassword("badpassword");
        return credentials;
    }
}

