/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter;
import org.jasig.inspektr.common.web.ClientInfo;
import org.jasig.inspektr.common.web.ClientInfoHolder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockHttpServletResponse;

public abstract class AbstractThrottledSubmissionHandlerInterceptorAdapterTests {
    protected static final int FAILURE_RANGE = 5;
    protected static final int FAILURE_THRESHOLD = 10;
    protected static final String IP_ADDRESS = "1.2.3.4";
    protected static final ClientInfo CLIENT_INFO = new ClientInfo("1.2.3.4", "1.2.3.4");
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Before
    public void setUp() throws Exception {
        ClientInfoHolder.setClientInfo((ClientInfo)CLIENT_INFO);
    }

    @After
    public void tearDown() throws Exception {
        ClientInfoHolder.setClientInfo(null);
    }

    @Test
    public void verifyThrottle() throws Exception {
        this.getThrottle().setFailureRangeInSeconds(5);
        this.getThrottle().setFailureThreshold(10);
        this.getThrottle().afterPropertiesSet();
        int wait = 535;
        this.failLoop(3, wait, 200);
        wait = 465;
        this.failLoop(3, wait, 403);
        wait = 535;
        Thread.sleep(wait);
        this.failLoop(3, wait, 200);
    }

    private void failLoop(int trials, int period, int expected) throws Exception {
        this.loginUnsuccessfully("mog", IP_ADDRESS).getStatus();
        int i = 0;
        while (i < trials) {
            this.logger.debug("Waiting for {} ms", (Object)period);
            Thread.sleep(period);
            Assert.assertEquals((long)expected, (long)this.loginUnsuccessfully("mog", IP_ADDRESS).getStatus());
            ++i;
        }
    }

    protected abstract MockHttpServletResponse loginUnsuccessfully(String var1, String var2) throws Exception;

    protected abstract AbstractThrottledSubmissionHandlerInterceptorAdapter getThrottle();
}

