/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml.web.flow.mdui;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.support.saml.AbstractOpenSamlTests;
import org.jasig.cas.support.saml.web.flow.mdui.SamlMetadataUIParserAction;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

public class SamlMetadataUIParserActionTests
extends AbstractOpenSamlTests {
    @Autowired
    @Qualifier(value="samlMetadataUIParserAction")
    private SamlMetadataUIParserAction samlMetadataUIParserAction;
    @Autowired
    @Qualifier(value="samlDynamicMetadataUIParserAction")
    private SamlMetadataUIParserAction samlDynamicMetadataUIParserAction;

    @Test
    public void verifyEntityIdUIInfoExists() throws Exception {
        MockRequestContext ctx = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("entityId", "https://carmenwiki.osu.edu/shibboleth");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockServletContext sCtx = new MockServletContext();
        ctx.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)sCtx, (HttpServletRequest)request, (HttpServletResponse)response));
        this.samlMetadataUIParserAction.doExecute((RequestContext)ctx);
        Assert.assertTrue((boolean)ctx.getFlowScope().contains("mduiContext"));
    }

    @Test
    public void verifyEntityIdUIInfoExistsDynamically() throws Exception {
        MockRequestContext ctx = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("entityId", "https://carmenwiki.osu.edu/shibboleth");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockServletContext sCtx = new MockServletContext();
        ctx.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)sCtx, (HttpServletRequest)request, (HttpServletResponse)response));
        this.samlDynamicMetadataUIParserAction.doExecute((RequestContext)ctx);
        Assert.assertTrue((boolean)ctx.getFlowScope().contains("mduiContext"));
    }

    @Test
    public void verifyEntityIdUIInfoNoParam() throws Exception {
        MockRequestContext ctx = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("somethingelse", "https://carmenwiki.osu.edu/shibboleth");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockServletContext sCtx = new MockServletContext();
        ctx.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)sCtx, (HttpServletRequest)request, (HttpServletResponse)response));
        this.samlMetadataUIParserAction.doExecute((RequestContext)ctx);
        Assert.assertFalse((boolean)ctx.getFlowScope().contains("mduiContext"));
    }
}

