/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry.support;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.jasig.cas.ticket.registry.support.JpaLockingStrategy;
import org.jasig.cas.ticket.registry.support.LockingStrategy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.jpa.SharedEntityManagerCreator;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class JpaLockingStrategyTests {
    private static final int CONCURRENT_SIZE = 13;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PlatformTransactionManager txManager;
    private EntityManagerFactory factory;
    private DataSource dataSource;

    @Before
    public void setup() {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("classpath:/jpaSpringContext.xml");
        this.factory = (EntityManagerFactory)ctx.getBean("ticketEntityManagerFactory", EntityManagerFactory.class);
        this.txManager = (PlatformTransactionManager)ctx.getBean("ticketTransactionManager", PlatformTransactionManager.class);
        this.dataSource = (DataSource)ctx.getBean("dataSourceTicket", DataSource.class);
    }

    @Test
    public void verifyAcquireAndRelease() throws Exception {
        LockingStrategy lock = this.newLockTxProxy("basic", "basic-1", 3600);
        try {
            Assert.assertTrue((boolean)lock.acquire());
            Assert.assertEquals((Object)"basic-1", (Object)this.getOwner("basic"));
            lock.release();
            Assert.assertNull((Object)this.getOwner("basic"));
        }
        catch (Exception e) {
            this.logger.debug("testAcquireAndRelease produced an error", (Throwable)e);
            Assert.fail((String)"testAcquireAndRelease failed");
        }
    }

    @Test
    public void verifyLockExpiration() throws Exception {
        LockingStrategy lock = this.newLockTxProxy("expquick", "expquick-1", 1);
        try {
            Assert.assertTrue((boolean)lock.acquire());
            Assert.assertEquals((Object)"expquick-1", (Object)this.getOwner("expquick"));
            Assert.assertFalse((boolean)lock.acquire());
            Thread.sleep(1500L);
            Assert.assertTrue((boolean)lock.acquire());
            Assert.assertEquals((Object)"expquick-1", (Object)this.getOwner("expquick"));
            lock.release();
            Assert.assertNull((Object)this.getOwner("expquick"));
        }
        catch (Exception e) {
            this.logger.debug("testLockExpiration produced an error", (Throwable)e);
            Assert.fail((String)"testLockExpiration failed");
        }
    }

    @Test
    public void verifyNonReentrantBehavior() {
        LockingStrategy lock = this.newLockTxProxy("reentrant", "reentrant-1", 3600);
        try {
            Assert.assertTrue((boolean)lock.acquire());
            Assert.assertEquals((Object)"reentrant-1", (Object)this.getOwner("reentrant"));
            Assert.assertFalse((boolean)lock.acquire());
            lock.release();
            Assert.assertNull((Object)this.getOwner("reentrant"));
        }
        catch (Exception e) {
            this.logger.debug("testNonReentrantBehavior produced an error", (Throwable)e);
            Assert.fail((String)"testNonReentrantBehavior failed.");
        }
    }

    @Test
    public void verifyConcurrentAcquireAndRelease() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(13);
        try {
            try {
                this.testConcurrency(executor, this.getConcurrentLocks("concurrent-new"));
            }
            catch (Exception e) {
                this.logger.debug("testConcurrentAcquireAndRelease produced an error", (Throwable)e);
                Assert.fail((String)"testConcurrentAcquireAndRelease failed.");
                executor.shutdownNow();
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void verifyConcurrentAcquireAndReleaseOnExistingLock() throws Exception {
        LockingStrategy[] locks = this.getConcurrentLocks("concurrent-exists");
        locks[0].acquire();
        locks[0].release();
        ExecutorService executor = Executors.newFixedThreadPool(13);
        try {
            try {
                this.testConcurrency(executor, locks);
            }
            catch (Exception e) {
                this.logger.debug("testConcurrentAcquireAndReleaseOnExistingLock produced an error", (Throwable)e);
                Assert.fail((String)"testConcurrentAcquireAndReleaseOnExistingLock failed.");
                executor.shutdownNow();
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    private LockingStrategy[] getConcurrentLocks(String appId) {
        LockingStrategy[] locks = new LockingStrategy[13];
        int i = 1;
        while (i <= locks.length) {
            locks[i - 1] = this.newLockTxProxy(appId, String.valueOf(appId) + '-' + i, 3600);
            ++i;
        }
        return locks;
    }

    private LockingStrategy newLockTxProxy(String appId, String uniqueId, int ttl) {
        JpaLockingStrategy lock = new JpaLockingStrategy();
        lock.entityManager = SharedEntityManagerCreator.createSharedEntityManager((EntityManagerFactory)this.factory);
        lock.setApplicationId(appId);
        lock.setUniqueId(uniqueId);
        lock.setLockTimeout(ttl);
        return (LockingStrategy)Proxy.newProxyInstance(JpaLockingStrategy.class.getClassLoader(), new Class[]{LockingStrategy.class}, (InvocationHandler)new TransactionalLockInvocationHandler(lock, this.txManager));
    }

    private String getOwner(String appId) {
        JdbcTemplate simpleJdbcTemplate = new JdbcTemplate(this.dataSource);
        List results = simpleJdbcTemplate.queryForList("SELECT unique_id FROM locks WHERE application_id=?", new Object[]{appId});
        if (results.isEmpty()) {
            return null;
        }
        return (String)((Map)results.get(0)).get("unique_id");
    }

    private void testConcurrency(ExecutorService executor, LockingStrategy[] locks) throws Exception {
        ArrayList<Locker> lockers = new ArrayList<Locker>(locks.length);
        int i = 0;
        while (i < locks.length) {
            lockers.add(new Locker(locks[i]));
            ++i;
        }
        int lockCount = 0;
        for (Future result : executor.invokeAll(lockers)) {
            if (!((Boolean)result.get()).booleanValue()) continue;
            ++lockCount;
        }
        Assert.assertTrue((String)("Lock count should be <= 1 but was " + lockCount), (lockCount <= 1 ? 1 : 0) != 0);
        ArrayList<Releaser> releasers = new ArrayList<Releaser>(locks.length);
        int i2 = 0;
        while (i2 < locks.length) {
            releasers.add(new Releaser(locks[i2]));
            ++i2;
        }
        int releaseCount = 0;
        for (Future result : executor.invokeAll(lockers)) {
            if (!((Boolean)result.get()).booleanValue()) continue;
            ++releaseCount;
        }
        Assert.assertTrue((String)("Release count should be <= 1 but was " + releaseCount), (releaseCount <= 1 ? 1 : 0) != 0);
    }

    private static class Locker
    implements Callable<Boolean> {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final LockingStrategy lock;

        Locker(LockingStrategy l) {
            this.lock = l;
        }

        @Override
        public Boolean call() throws Exception {
            try {
                return this.lock.acquire();
            }
            catch (Exception e) {
                this.logger.debug("{} failed to acquire lock", (Object)this.lock, (Object)e);
                return false;
            }
        }
    }

    private static class Releaser
    implements Callable<Boolean> {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final LockingStrategy lock;

        Releaser(LockingStrategy l) {
            this.lock = l;
        }

        @Override
        public Boolean call() throws Exception {
            try {
                this.lock.release();
                return true;
            }
            catch (Exception e) {
                this.logger.debug("{} failed to release lock", (Object)this.lock, (Object)e);
                return false;
            }
        }
    }

    private static class TransactionalLockInvocationHandler
    implements InvocationHandler {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final JpaLockingStrategy jpaLock;
        private final PlatformTransactionManager txManager;

        TransactionalLockInvocationHandler(JpaLockingStrategy lock, PlatformTransactionManager txManager) {
            this.jpaLock = lock;
            this.txManager = txManager;
        }

        public JpaLockingStrategy getLock() {
            return this.jpaLock;
        }

        @Override
        public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
            return new TransactionTemplate(this.txManager).execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus status) {
                    try {
                        Object result = method.invoke((Object)TransactionalLockInvocationHandler.this.jpaLock, args);
                        ((TransactionalLockInvocationHandler)TransactionalLockInvocationHandler.this).jpaLock.entityManager.flush();
                        TransactionalLockInvocationHandler.this.logger.debug("Performed {} on {}", (Object)method.getName(), (Object)TransactionalLockInvocationHandler.this.jpaLock);
                        return result;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Transactional method invocation failed.", e);
                    }
                }
            });
        }
    }
}

