/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jasig.cas.authentication.TestUtils;
import org.jasig.cas.authentication.principal.DefaultPrincipalFactory;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.mock.MockService;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.UniqueTicketIdGenerator;
import org.jasig.cas.ticket.proxy.ProxyGrantingTicket;
import org.jasig.cas.ticket.proxy.ProxyTicket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.ticket.support.HardTimeoutExpirationPolicy;
import org.jasig.cas.ticket.support.MultiTimeUseOrTimeoutExpirationPolicy;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class JpaTicketRegistryTests {
    private static final int CONCURRENT_SIZE = 20;
    private static final UniqueTicketIdGenerator ID_GENERATOR = new DefaultUniqueTicketIdGenerator(64);
    private static final ExpirationPolicy EXP_POLICY_TGT = new HardTimeoutExpirationPolicy(1000L);
    private static final ExpirationPolicy EXP_POLICY_ST = new MultiTimeUseOrTimeoutExpirationPolicy(1, 1000L);
    private static final ExpirationPolicy EXP_POLICY_PGT = new HardTimeoutExpirationPolicy(2000L);
    private static final ExpirationPolicy EXP_POLICY_PT = new MultiTimeUseOrTimeoutExpirationPolicy(1, 2000L);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PlatformTransactionManager txManager;
    private TicketRegistry jpaTicketRegistry;

    @Before
    public void setup() {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("classpath:/jpaSpringContext.xml");
        this.jpaTicketRegistry = (TicketRegistry)ctx.getBean("jpaTicketRegistry", TicketRegistry.class);
        this.txManager = (PlatformTransactionManager)ctx.getBean("ticketTransactionManager", PlatformTransactionManager.class);
    }

    @Test
    public void verifyTicketCreationAndDeletion() throws Exception {
        TicketGrantingTicket newTgt = JpaTicketRegistryTests.newTGT();
        this.addTicketInTransaction((Ticket)newTgt);
        TicketGrantingTicket tgtFromDb = (TicketGrantingTicket)this.getTicketInTransaction(newTgt.getId());
        Assert.assertNotNull((Object)tgtFromDb);
        Assert.assertEquals((Object)newTgt.getId(), (Object)tgtFromDb.getId());
        ServiceTicket newSt = this.grantServiceTicketInTransaction(tgtFromDb);
        ServiceTicket stFromDb = (ServiceTicket)this.getTicketInTransaction(newSt.getId());
        Assert.assertNotNull((Object)stFromDb);
        Assert.assertEquals((Object)newSt.getId(), (Object)stFromDb.getId());
        ProxyGrantingTicket newPgt = this.grantProxyGrantingTicketInTransaction(stFromDb);
        ProxyGrantingTicket pgtFromDb = (ProxyGrantingTicket)this.getTicketInTransaction(newPgt.getId());
        Assert.assertNotNull((Object)pgtFromDb);
        Assert.assertEquals((Object)newPgt.getId(), (Object)pgtFromDb.getId());
        ProxyTicket newPt = this.grantProxyTicketInTransaction(pgtFromDb);
        ProxyTicket ptFromDb = (ProxyTicket)this.getTicketInTransaction(newPt.getId());
        Assert.assertNotNull((Object)ptFromDb);
        Assert.assertEquals((Object)newPt.getId(), (Object)ptFromDb.getId());
        this.deleteTicketInTransaction(newTgt.getId());
        Assert.assertNull((Object)this.getTicketInTransaction(newTgt.getId()));
        Assert.assertNull((Object)this.getTicketInTransaction(newSt.getId()));
        Assert.assertNull((Object)this.getTicketInTransaction(newPgt.getId()));
        Assert.assertNull((Object)this.getTicketInTransaction(newPt.getId()));
    }

    @Test
    public void verifyConcurrentServiceTicketGeneration() throws Exception {
        TicketGrantingTicket newTgt = JpaTicketRegistryTests.newTGT();
        this.addTicketInTransaction((Ticket)newTgt);
        ExecutorService executor = Executors.newFixedThreadPool(20);
        try {
            try {
                ArrayList<ServiceTicketGenerator> generators = new ArrayList<ServiceTicketGenerator>(20);
                int i = 0;
                while (i < 20) {
                    generators.add(new ServiceTicketGenerator(newTgt.getId(), this.jpaTicketRegistry, this.txManager));
                    ++i;
                }
                List results = executor.invokeAll(generators);
                for (Future result : results) {
                    Assert.assertNotNull(result.get());
                }
            }
            catch (Exception e) {
                this.logger.error("testConcurrentServiceTicketGeneration produced an error", (Throwable)e);
                Assert.fail((String)"testConcurrentServiceTicketGeneration failed.");
                executor.shutdownNow();
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    static TicketGrantingTicket newTGT() {
        Principal principal = new DefaultPrincipalFactory().createPrincipal("bob", Collections.singletonMap("displayName", "Bob"));
        return new TicketGrantingTicketImpl(ID_GENERATOR.getNewTicketId("TGT"), TestUtils.getAuthentication((Principal)principal), EXP_POLICY_TGT);
    }

    static ServiceTicket newST(TicketGrantingTicket parent) {
        return parent.grantServiceTicket(ID_GENERATOR.getNewTicketId("ST"), (Service)new MockService("https://service.example.com"), EXP_POLICY_ST, false, true);
    }

    static ProxyGrantingTicket newPGT(ServiceTicket parent) {
        return parent.grantProxyGrantingTicket(ID_GENERATOR.getNewTicketId("PGT"), TestUtils.getAuthentication(), EXP_POLICY_PGT);
    }

    static ProxyTicket newPT(ProxyGrantingTicket parent) {
        return parent.grantProxyTicket(ID_GENERATOR.getNewTicketId("PT"), (Service)new MockService("https://proxy-service.example.com"), EXP_POLICY_PT, false);
    }

    void addTicketInTransaction(final Ticket ticket) {
        new TransactionTemplate(this.txManager).execute((TransactionCallback)new TransactionCallback<Object>(){

            public Void doInTransaction(TransactionStatus status) {
                JpaTicketRegistryTests.this.jpaTicketRegistry.addTicket(ticket);
                return null;
            }
        });
    }

    void deleteTicketInTransaction(final String ticketId) {
        new TransactionTemplate(this.txManager).execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction(TransactionStatus status) {
                JpaTicketRegistryTests.this.jpaTicketRegistry.deleteTicket(ticketId);
                return null;
            }
        });
    }

    Ticket getTicketInTransaction(final String ticketId) {
        return (Ticket)new TransactionTemplate(this.txManager).execute((TransactionCallback)new TransactionCallback<Ticket>(){

            public Ticket doInTransaction(TransactionStatus status) {
                return JpaTicketRegistryTests.this.jpaTicketRegistry.getTicket(ticketId);
            }
        });
    }

    ServiceTicket grantServiceTicketInTransaction(final TicketGrantingTicket parent) {
        return (ServiceTicket)new TransactionTemplate(this.txManager).execute((TransactionCallback)new TransactionCallback<ServiceTicket>(){

            public ServiceTicket doInTransaction(TransactionStatus status) {
                ServiceTicket st = JpaTicketRegistryTests.newST(parent);
                JpaTicketRegistryTests.this.jpaTicketRegistry.addTicket((Ticket)st);
                return st;
            }
        });
    }

    ProxyGrantingTicket grantProxyGrantingTicketInTransaction(final ServiceTicket parent) {
        return (ProxyGrantingTicket)new TransactionTemplate(this.txManager).execute((TransactionCallback)new TransactionCallback<ProxyGrantingTicket>(){

            public ProxyGrantingTicket doInTransaction(TransactionStatus status) {
                ProxyGrantingTicket pgt = JpaTicketRegistryTests.newPGT(parent);
                JpaTicketRegistryTests.this.jpaTicketRegistry.addTicket((Ticket)pgt);
                return pgt;
            }
        });
    }

    ProxyTicket grantProxyTicketInTransaction(final ProxyGrantingTicket parent) {
        return (ProxyTicket)new TransactionTemplate(this.txManager).execute((TransactionCallback)new TransactionCallback<ProxyTicket>(){

            public ProxyTicket doInTransaction(TransactionStatus status) {
                ProxyTicket st = JpaTicketRegistryTests.newPT(parent);
                JpaTicketRegistryTests.this.jpaTicketRegistry.addTicket((Ticket)st);
                return st;
            }
        });
    }

    private static class ServiceTicketGenerator
    implements Callable<String> {
        private final PlatformTransactionManager txManager;
        private final String parentTgtId;
        private final TicketRegistry jpaTicketRegistry;

        ServiceTicketGenerator(String tgtId, TicketRegistry jpaTicketRegistry, PlatformTransactionManager txManager) {
            this.parentTgtId = tgtId;
            this.jpaTicketRegistry = jpaTicketRegistry;
            this.txManager = txManager;
        }

        @Override
        public String call() throws Exception {
            return (String)new TransactionTemplate(this.txManager).execute((TransactionCallback)new TransactionCallback<String>(){

                public String doInTransaction(TransactionStatus status) {
                    ServiceTicket st = JpaTicketRegistryTests.newST((TicketGrantingTicket)ServiceTicketGenerator.this.jpaTicketRegistry.getTicket(ServiceTicketGenerator.this.parentTgtId));
                    ServiceTicketGenerator.this.jpaTicketRegistry.addTicket((Ticket)st);
                    return st.getId();
                }
            });
        }
    }
}

