/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import org.jasig.cas.authentication.TestUtils;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.mock.MockService;
import org.jasig.cas.monitor.SessionMonitor;
import org.jasig.cas.monitor.SessionStatus;
import org.jasig.cas.monitor.StatusCode;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.UniqueTicketIdGenerator;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.ticket.registry.TicketRegistryState;
import org.jasig.cas.ticket.support.HardTimeoutExpirationPolicy;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class SessionMonitorJpaTests {
    private static final ExpirationPolicy TEST_EXP_POLICY = new HardTimeoutExpirationPolicy(10000L);
    private static final UniqueTicketIdGenerator GENERATOR = new DefaultUniqueTicketIdGenerator();
    private TicketRegistry jpaRegistry;
    private SessionMonitor monitor;

    @Before
    public void setup() {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("classpath:/jpaSpringContext.xml");
        this.jpaRegistry = (TicketRegistry)ctx.getBean("jpaTicketRegistry", TicketRegistry.class);
        this.monitor = new SessionMonitor();
    }

    @Test
    @Rollback(value=false)
    public void verifyObserveOkJpaTicketRegistry() throws Exception {
        this.addTicketsToRegistry(this.jpaRegistry, 5, 5);
        Assert.assertEquals((long)10L, (long)this.jpaRegistry.getTickets().size());
        this.monitor.setTicketRegistry((TicketRegistryState)this.jpaRegistry);
        SessionStatus status = this.monitor.observe();
        Assert.assertEquals((long)5L, (long)status.getSessionCount());
        Assert.assertEquals((long)5L, (long)status.getServiceTicketCount());
        Assert.assertEquals((Object)StatusCode.OK, (Object)status.getCode());
    }

    private void addTicketsToRegistry(TicketRegistry registry, int tgtCount, int stCount) {
        TicketGrantingTicketImpl ticket = null;
        int i = 0;
        while (i < tgtCount) {
            ticket = new TicketGrantingTicketImpl(GENERATOR.getNewTicketId("TGT"), TestUtils.getAuthentication(), TEST_EXP_POLICY);
            registry.addTicket((Ticket)ticket);
            ++i;
        }
        if (ticket != null) {
            i = 0;
            while (i < stCount) {
                registry.addTicket((Ticket)ticket.grantServiceTicket(GENERATOR.getNewTicketId("ST"), (Service)new MockService("junit"), TEST_EXP_POLICY, false, true));
                ++i;
            }
        }
    }
}

