/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import java.util.Formatter;
import net.sf.ehcache.Cache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.statistics.StatisticsGateway;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.monitor.CacheStatistics;

public class EhCacheStatistics
implements CacheStatistics {
    private static final double TOTAL_NUMBER_BYTES_IN_ONE_MEGABYTE = 1048510.0;
    private static final int PERCENTAGE_VALUE = 100;
    private final Cache cache;
    private boolean useBytes;
    private long diskSize;
    private long heapSize;
    private long offHeapSize;

    public EhCacheStatistics(Cache cache) {
        this.cache = cache;
        if (cache.getCacheConfiguration().getMaxBytesLocalDisk() > 0L) {
            this.useBytes = true;
        }
    }

    public long getSize() {
        StatisticsGateway statistics = this.cache.getStatistics();
        if (this.useBytes) {
            this.diskSize = statistics.getLocalDiskSizeInBytes();
            this.heapSize = statistics.getLocalHeapSizeInBytes();
        } else {
            this.diskSize = this.cache.getDiskStoreSize();
            this.heapSize = this.cache.getMemoryStoreSize();
        }
        this.offHeapSize = statistics.getLocalOffHeapSizeInBytes();
        return this.heapSize;
    }

    public long getCapacity() {
        CacheConfiguration config = this.cache.getCacheConfiguration();
        if (this.useBytes) {
            return config.getMaxBytesLocalDisk();
        }
        return config.getMaxElementsOnDisk();
    }

    public long getEvictions() {
        return this.cache.getStatistics().cacheEvictedCount();
    }

    public int getPercentFree() {
        long capacity = this.getCapacity();
        if (capacity == 0L) {
            return 0;
        }
        return (int)((capacity - this.getSize()) * 100L / capacity);
    }

    public String getName() {
        return this.cache.getName();
    }

    public void toString(StringBuilder builder) {
        String name = this.getName();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            builder.append(name).append(':');
        }
        int free = this.getPercentFree();
        Formatter formatter = new Formatter(builder);
        if (this.useBytes) {
            formatter.format("%.2f", (double)this.heapSize / 1048510.0);
            builder.append("MB heap, ");
            formatter.format("%.2f", (double)this.diskSize / 1048510.0);
            builder.append("MB disk, ");
        } else {
            builder.append(this.heapSize).append(" items in heap, ");
            builder.append(this.diskSize).append(" items on disk, ");
        }
        formatter.format("%.2f", (double)this.offHeapSize / 1048510.0);
        builder.append("MB off-heap, ");
        builder.append(free).append("% free, ");
        builder.append(this.getEvictions()).append(" evictions");
        formatter.close();
    }
}

