/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.jasig.cas.monitor.CacheStatistics;
import org.jasig.cas.monitor.CacheStatus;
import org.jasig.cas.monitor.EhCacheMonitor;
import org.jasig.cas.monitor.StatusCode;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(value={"/ehcacheMonitor-test.xml"})
public class EhCacheMonitorTests {
    @Autowired
    private Cache cache;
    @Autowired
    private EhCacheMonitor monitor;

    @Test
    public void verifyObserve() throws Exception {
        CacheStatus status = this.monitor.observe();
        CacheStatistics stats = status.getStatistics()[0];
        Assert.assertEquals((long)100L, (long)stats.getCapacity());
        Assert.assertEquals((long)0L, (long)stats.getSize());
        Assert.assertEquals((Object)StatusCode.OK, (Object)status.getCode());
        int i = 0;
        while (i < 95) {
            this.cache.put(new Element((Serializable)((Object)("key" + i)), (Serializable)((Object)("value" + i))));
            ++i;
        }
        status = this.monitor.observe();
        stats = status.getStatistics()[0];
        Assert.assertEquals((long)100L, (long)stats.getCapacity());
        Assert.assertEquals((long)95L, (long)stats.getSize());
        Assert.assertEquals((Object)StatusCode.WARN, (Object)status.getCode());
        i = 95;
        while (i < 110) {
            this.cache.put(new Element((Serializable)((Object)("key" + i)), (Serializable)((Object)("value" + i))));
            ++i;
        }
        status = this.monitor.observe();
        stats = status.getStatistics()[0];
        Assert.assertEquals((long)100L, (long)stats.getCapacity());
        Assert.assertEquals((long)100L, (long)stats.getSize());
        Assert.assertEquals((Object)StatusCode.WARN, (Object)status.getCode());
    }
}

