/*
 * Decompiled with CFR 0.152.
 */
package org.japprove.verifier;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.japprove.engine.ApprovalTestingEngine;
import org.japprove.exceptions.BaselineCandidateCreationFailedException;
import org.japprove.exceptions.BaselineNotFoundException;
import org.japprove.exceptions.VerificationFailedException;
import org.japprove.exceptions.errors.VerificationFailedError;
import org.japprove.exceptions.errors.VersionNotApprovedError;
import org.japprove.verifier.Verifier;

public class StringVerifier
extends Verifier {
    private static final Logger LOGGER = LogManager.getLogger(StringVerifier.class);

    public StringVerifier(ApprovalTestingEngine approvalTestingEngine) {
        super(approvalTestingEngine);
    }

    public void verify(String data) {
        String baselineData;
        LOGGER.info("Starting new approval test with baseline: " + this.baselineName);
        try {
            baselineData = this.baselineRepository.getContentOfTextBaseline(this.baselineName);
        }
        catch (BaselineNotFoundException e) {
            LOGGER.info("No approved version found");
            LOGGER.info("Creating new baseline candidate");
            this.createBaselineCandidate(data);
            throw new VersionNotApprovedError(this.baselineName);
        }
        if (!baselineData.equals(data)) {
            LOGGER.info("Current version is not equal to approved version");
            LOGGER.info("Create new baseline candidate");
            String differences = this.differ.getDifferences(baselineData, data);
            this.createBaselineCandidate(data);
            throw new VerificationFailedError(differences);
        }
        LOGGER.info("Current version is equal to approved version");
        this.baselineRepository.removeBaselineCandidate(this.baselineName);
    }

    public void verify(List<String> data) {
        this.verify(String.join((CharSequence)"\n", data));
    }

    private void createBaselineCandidate(String data) {
        try {
            this.baselineRepository.createBaselineCandidate(data, this.baselineName);
        }
        catch (BaselineCandidateCreationFailedException e) {
            throw new VerificationFailedException("Internal error while creating baseline");
        }
    }
}

