/*
 * Decompiled with CFR 0.152.
 */
package org.japprove.verifier;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.japprove.engine.ApprovalTestingEngine;
import org.japprove.exceptions.BaselineCandidateCreationFailedException;
import org.japprove.exceptions.BaselineNotFoundException;
import org.japprove.exceptions.VerificationFailedException;
import org.japprove.exceptions.errors.VerificationFailedError;
import org.japprove.exceptions.errors.VersionNotApprovedError;
import org.japprove.verifier.Verifier;

public class JsonVerifier
extends Verifier {
    private static final Logger LOGGER = LogManager.getLogger(JsonVerifier.class);
    private List<String> ignoredFields = new ArrayList<String>();

    public JsonVerifier(ApprovalTestingEngine approvalTestingEngine) {
        super(approvalTestingEngine);
    }

    public void verify(JsonNode data) {
        JsonNode baselineData;
        LOGGER.info("Starting new approval test with baseline: " + this.baselineName);
        try {
            baselineData = this.baselineRepository.getContentOfJsonBaseline(this.baselineName);
        }
        catch (BaselineNotFoundException e) {
            LOGGER.info("No approved version found");
            LOGGER.info("Creating new baseline candidate");
            this.createBaselineCandidate(data);
            throw new VersionNotApprovedError(this.baselineName);
        }
        JsonNode dataWithoutIgnoredFields = this.removeIgnoredFields(data);
        JsonNode baselineWithoutIgnoredFields = this.removeIgnoredFields(baselineData);
        if (!baselineWithoutIgnoredFields.equals((Object)dataWithoutIgnoredFields)) {
            LOGGER.info("Current version is not equal to approved version");
            LOGGER.info("Create new baseline candidate");
            String differences = this.differ.getDifferences(baselineWithoutIgnoredFields, dataWithoutIgnoredFields);
            this.createBaselineCandidate(data);
            throw new VerificationFailedError(differences);
        }
        LOGGER.info("Current version is equal to approved version");
        this.baselineRepository.removeBaselineCandidate(this.baselineName);
    }

    public JsonVerifier ignore(String jsonPath) {
        LOGGER.info("Ignoring Json element in approval test: " + jsonPath);
        this.ignoredFields.add(jsonPath);
        return this;
    }

    private void createBaselineCandidate(JsonNode data) {
        try {
            this.baselineRepository.createBaselineCandidate(data, this.baselineName);
        }
        catch (BaselineCandidateCreationFailedException e) {
            throw new VerificationFailedException("Internal error while creating baseline");
        }
    }

    private JsonNode removeIgnoredFields(JsonNode jsonToApprove) {
        DocumentContext jsonContext = JsonPath.parse((String)jsonToApprove.toString());
        for (String ignoredField : this.ignoredFields) {
            jsonToApprove = this.stringToJson(jsonContext.delete(ignoredField, new Predicate[0]).jsonString());
        }
        return jsonToApprove;
    }

    private JsonNode stringToJson(String jsonString) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.readTree(jsonString);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading Json String");
        }
    }
}

