/*
 * Decompiled with CFR 0.152.
 */
package org.japprove.repositories;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.algorithm.DiffException;
import com.github.difflib.patch.Patch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.japprove.config.ApprovalTestingConfiguration;
import org.japprove.exceptions.BaselineCandidateCreationFailedException;
import org.japprove.exceptions.BaselineCandidateNotFoundException;
import org.japprove.exceptions.BaselineCreationFailedException;
import org.japprove.exceptions.BaselineNotFoundException;
import org.japprove.exceptions.CopyingFailedException;
import org.japprove.exceptions.DiffingFailedException;
import org.japprove.exceptions.FileCreationFailedException;
import org.japprove.files.JsonFile;
import org.japprove.files.TextFile;
import org.japprove.repositories.BaselineRepository;

public class BaselineRepositoryImpl
implements BaselineRepository {
    static final String TXT_EXTENSION = ".txt";
    private String baselineDirectory;
    private String baselineCandidateDirectory;

    public BaselineRepositoryImpl(ApprovalTestingConfiguration config) {
        this.baselineDirectory = config.getBaselineDirectory();
        this.baselineCandidateDirectory = config.getBaselineCandidateDirectory();
    }

    @Override
    public void createBaselineCandidate(String data, String name) throws BaselineCandidateCreationFailedException {
        TextFile baselineCandidate = new TextFile(this.baselineCandidateDirectory + name + TXT_EXTENSION);
        try {
            baselineCandidate.create();
            baselineCandidate.writeData(data);
        }
        catch (IOException | FileCreationFailedException e) {
            throw new BaselineCandidateCreationFailedException(baselineCandidate.getName());
        }
    }

    @Override
    public void createBaselineCandidate(JsonNode data, String name) throws BaselineCandidateCreationFailedException {
        JsonFile baselineCandidate = new JsonFile(this.baselineCandidateDirectory + name + TXT_EXTENSION);
        try {
            baselineCandidate.create();
            baselineCandidate.writeData(data);
        }
        catch (JsonProcessingException | FileNotFoundException | FileCreationFailedException e) {
            throw new BaselineCandidateCreationFailedException(baselineCandidate.getName());
        }
    }

    @Override
    public boolean removeBaselineCandidate(String name) {
        try {
            return this.getFile(name, this.baselineCandidateDirectory).delete();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Override
    public List<String> getBaselineCandidateNames() {
        File directory = new File(this.baselineCandidateDirectory);
        ArrayList<String> baselineCandidateNames = new ArrayList<String>();
        if (directory.exists() && directory.listFiles() != null) {
            for (File file : directory.listFiles()) {
                baselineCandidateNames.add(file.getName().replace(TXT_EXTENSION, ""));
            }
        }
        return baselineCandidateNames;
    }

    @Override
    public JsonNode getContentOfJsonBaseline(String baseline) throws BaselineNotFoundException {
        return this.getJsonBaseline(baseline).readData();
    }

    @Override
    public String getContentOfTextBaseline(String baseline) throws BaselineNotFoundException {
        try {
            return this.getTextBaseline(baseline).readData();
        }
        catch (IOException e) {
            throw new BaselineNotFoundException(baseline);
        }
    }

    @Override
    public void copyBaselineCandidateToBaseline(String baselineCandidateName) throws BaselineCandidateNotFoundException, BaselineCreationFailedException, CopyingFailedException {
        TextFile baseline;
        TextFile baselineCandidate;
        try {
            baselineCandidate = this.getFile(baselineCandidateName, this.baselineCandidateDirectory);
        }
        catch (FileNotFoundException e) {
            throw new BaselineCandidateNotFoundException(baselineCandidateName);
        }
        try {
            baseline = this.getFile(baselineCandidateName, this.baselineDirectory);
        }
        catch (FileNotFoundException e) {
            try {
                baseline = this.createBaseline(baselineCandidateName);
            }
            catch (BaselineCreationFailedException ex) {
                throw new BaselineCreationFailedException(baselineCandidateName);
            }
        }
        try {
            this.copyFiles(baselineCandidate, baseline);
        }
        catch (IOException e) {
            throw new CopyingFailedException("Cannot copy content of " + baselineCandidateName + " to the baseline");
        }
    }

    @Override
    public String getDifferences(String baselineCandidateName) throws BaselineCandidateNotFoundException, BaselineNotFoundException {
        TextFile baseline;
        TextFile baselineCandidateFile;
        try {
            baselineCandidateFile = this.getFile(baselineCandidateName, this.baselineCandidateDirectory);
        }
        catch (FileNotFoundException e) {
            throw new BaselineCandidateNotFoundException(baselineCandidateName);
        }
        try {
            baseline = this.getFile(baselineCandidateName, this.baselineDirectory);
        }
        catch (FileNotFoundException e) {
            throw new BaselineNotFoundException(baselineCandidateName);
        }
        return this.formatDifferences(this.computeDifferences(baselineCandidateFile, baseline));
    }

    @Override
    public boolean baselineExists(String baselineCandidateName) {
        try {
            this.getFile(baselineCandidateName, this.baselineDirectory);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        return true;
    }

    @Override
    public File getBaselineCandidateAsFile(String name) throws IOException {
        return this.getFile(name, this.baselineCandidateDirectory);
    }

    @Override
    public File getBaselineAsFile(String name) throws IOException {
        return this.getFile(name, this.baselineDirectory);
    }

    private List<String> computeDifferences(TextFile revisedFile, TextFile originalFile) {
        try {
            List<String> original = this.readFileLineByLine(originalFile.getPath());
            List<String> revised = this.readFileLineByLine(revisedFile.getPath());
            Patch patch = DiffUtils.diff(original, revised);
            return UnifiedDiffUtils.generateUnifiedDiff((String)"Baseline", (String)"toApprove", original, (Patch)patch, (int)0);
        }
        catch (DiffException | IOException e) {
            throw new DiffingFailedException("Cannot compute differences! " + e);
        }
    }

    private List<String> readFileLineByLine(String fileName) throws IOException {
        String line;
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        while ((line = reader.readLine()) != null) {
            result.add(line);
        }
        reader.close();
        return result;
    }

    private String formatDifferences(List<String> differences) {
        StringBuilder builder = new StringBuilder();
        for (String difference : differences) {
            builder.append(difference);
            builder.append("\n");
        }
        return builder.toString();
    }

    private TextFile getTextBaseline(String baselineName) throws BaselineNotFoundException {
        TextFile baseline = new TextFile(this.baselineDirectory + baselineName + TXT_EXTENSION);
        if (!baseline.exists()) {
            throw new BaselineNotFoundException(baselineName);
        }
        return baseline;
    }

    private JsonFile getJsonBaseline(String baselineName) throws BaselineNotFoundException {
        JsonFile baseline = new JsonFile(this.baselineDirectory + baselineName + TXT_EXTENSION);
        if (!baseline.exists()) {
            throw new BaselineNotFoundException(baselineName);
        }
        return baseline;
    }

    private TextFile createBaseline(String baselineName) throws BaselineCreationFailedException {
        TextFile baseline = new TextFile(this.baselineDirectory + baselineName + TXT_EXTENSION);
        try {
            baseline.create();
        }
        catch (FileCreationFailedException e) {
            throw new BaselineCreationFailedException(baseline.getName());
        }
        return baseline;
    }

    private TextFile getFile(String baselineCandidateName, String directoryPath) throws FileNotFoundException {
        File directory = new File(directoryPath);
        if (directory.exists() && directory.listFiles() != null) {
            for (File file : directory.listFiles()) {
                if (!file.getPath().equals(directoryPath + baselineCandidateName) && !file.getPath().equals(directoryPath + baselineCandidateName + TXT_EXTENSION)) continue;
                return new TextFile(file.getPath());
            }
        }
        throw new FileNotFoundException(baselineCandidateName);
    }

    private void copyFiles(TextFile from, TextFile to) throws IOException {
        FileInputStream inputStream = new FileInputStream(from);
        FileOutputStream outputStream = new FileOutputStream(to);
        inputStream.getChannel().transferTo(0L, from.length(), outputStream.getChannel());
        inputStream.close();
        outputStream.close();
    }
}

