/*
 * Decompiled with CFR 0.152.
 */
package org.japprove.parameterresolver;

import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;

public abstract class ApprovalTestParameterResolver {
    private static final String EMPTY_STRING = "";
    private static final String BACKSLASH = "\"";

    public abstract boolean supportsParameter(ParameterContext var1, ExtensionContext var2) throws ParameterResolutionException;

    public abstract Object resolveParameter(ParameterContext var1, ExtensionContext var2) throws ParameterResolutionException;

    String getBaselineName(ExtensionContext extensionContext) {
        String annotationParameter = this.getAnnotationParameter(extensionContext);
        if (annotationParameter.equals(EMPTY_STRING)) {
            return this.createBaselineNameByHashCode(extensionContext);
        }
        return annotationParameter;
    }

    private String getAnnotationParameter(ExtensionContext extensionContext) {
        String declaredAnnotation = ((Method)extensionContext.getTestMethod().get()).getDeclaredAnnotations()[0].toString();
        declaredAnnotation = declaredAnnotation.substring(declaredAnnotation.indexOf(BACKSLASH) + 1);
        declaredAnnotation = declaredAnnotation.substring(0, declaredAnnotation.indexOf(BACKSLASH));
        return declaredAnnotation;
    }

    private String createBaselineNameByHashCode(ExtensionContext extensionContext) {
        long hashCodeClass = Math.abs(((Class)extensionContext.getTestClass().get()).hashCode());
        long hashCodeMethod = Math.abs(((Method)extensionContext.getTestMethod().get()).hashCode());
        String filename = Long.toString(hashCodeClass) + hashCodeMethod;
        return filename;
    }
}

