/*
 * Decompiled with CFR 0.152.
 */
package org.japprove.files;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.japprove.exceptions.FileCreationFailedException;

public class TextFile
extends File {
    public TextFile(String path) {
        super(path);
    }

    public void writeData(String data) throws FileNotFoundException {
        PrintWriter out = new PrintWriter(this);
        out.print(data);
        out.close();
    }

    public String readData() throws IOException {
        return Files.readString(this.toPath(), StandardCharsets.US_ASCII);
    }

    public void create() throws FileCreationFailedException {
        if (!this.exists()) {
            File parent = this.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new FileCreationFailedException(parent.getName());
            }
            try {
                this.createNewFile();
            }
            catch (IOException e) {
                throw new FileCreationFailedException(parent.getName());
            }
        }
    }
}

