/*
 * Decompiled with CFR 0.152.
 */
package org.japprove.files;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.japprove.exceptions.FileCreationFailedException;
import org.japprove.files.TextFile;

public class JsonFile {
    private TextFile textFile;

    public JsonFile(String path) {
        this.textFile = new TextFile(path);
    }

    public void writeData(JsonNode data) throws FileNotFoundException, JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        this.textFile.writeData(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)data));
    }

    public JsonNode readData() {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.readTree(this.textFile.readData());
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading Json file");
        }
    }

    public void create() throws FileCreationFailedException {
        this.textFile.create();
    }

    public String getName() {
        return this.textFile.getName();
    }

    public boolean exists() {
        return this.textFile.exists();
    }
}

