/*
 * Decompiled with CFR 0.152.
 */
package org.japprove.differ;

import com.fasterxml.jackson.databind.JsonNode;
import com.flipkart.zjsonpatch.JsonDiff;
import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.algorithm.DiffException;
import com.github.difflib.patch.Patch;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.japprove.engine.ApprovalTestingEngine;
import org.japprove.exceptions.DiffingFailedException;
import org.japprove.repositories.BaselineRepositoryImpl;

public class Differ {
    private static final String BACKSLASH = "\"";
    private static final String EMPTY_STRING = "";
    private static final String SLASH = "/";
    private static final String REMOVE = "\"remove\"";
    private static final String ADD = "\"add\"";
    private static final String COPY = "\"copy\"";
    private static final String MOVE = "\"move\"";
    private static final String PATH = "path";
    private static final String OPERATION = "op";
    private static final String FROM = "from";
    private BaselineRepositoryImpl baselineRepository;
    private String pathToDiffTool;

    public Differ(ApprovalTestingEngine approvalTestingEngine, String pathToDiffTool) {
        this.baselineRepository = (BaselineRepositoryImpl)approvalTestingEngine.getBaselineRepository();
        this.pathToDiffTool = pathToDiffTool;
    }

    public void callExternalDiffTool(String baselineCandidateName) {
        File baseline;
        File baselineCandidate;
        try {
            baselineCandidate = this.baselineRepository.getBaselineCandidateAsFile(baselineCandidateName);
        }
        catch (IOException e) {
            throw new DiffingFailedException("Baseline candidate " + baselineCandidateName + " not found!");
        }
        try {
            baseline = this.baselineRepository.getBaselineAsFile(baselineCandidateName);
        }
        catch (IOException e) {
            throw new DiffingFailedException("Baseline " + baselineCandidateName + " not found!");
        }
        String cmd = this.pathToDiffTool + " " + baselineCandidate.getPath() + " " + baseline.getPath();
        try {
            Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            throw new DiffingFailedException("Diff tool " + this.pathToDiffTool + " not found!");
        }
    }

    public String getDifferences(String original, String revised) {
        try {
            Patch patch = DiffUtils.diff(Arrays.asList(original), Arrays.asList(revised));
            List differences = UnifiedDiffUtils.generateUnifiedDiff((String)"Baseline", (String)"Baseline Candidate", Arrays.asList(original), (Patch)patch, (int)0);
            return this.formatDifferences(differences);
        }
        catch (DiffException e) {
            throw new RuntimeException("Cannot compute differences! " + (Object)((Object)e));
        }
    }

    public String getDifferences(JsonNode original, JsonNode revised) {
        StringBuilder differences = new StringBuilder();
        JsonNode changes = JsonDiff.asJson((JsonNode)original, (JsonNode)revised);
        for (JsonNode change : changes) {
            differences.append(this.visualizeChange(change, revised, original));
            differences.append("\n");
        }
        return differences.toString();
    }

    private String formatDifferences(List<String> differences) {
        StringBuilder builder = new StringBuilder();
        for (String difference : differences) {
            builder.append(difference);
            builder.append("\n");
        }
        return builder.toString();
    }

    private String visualizeChange(JsonNode change, JsonNode revised, JsonNode original) {
        StringBuilder builder = new StringBuilder();
        String path = change.get(PATH).toString();
        String operation = change.get(OPERATION).toString();
        JsonNode newElement = this.getLeafOfJsonNode(path, revised);
        JsonNode oldElement = this.getLeafOfJsonNode(path, original);
        builder.append("Operation: " + operation + "\n");
        builder.append("Path: " + path + "\n");
        if (operation.equals(REMOVE)) {
            builder.append("--- " + oldElement + " \n");
        } else if (operation.equals(ADD) || operation.equals(COPY)) {
            builder.append("+++ " + newElement + " \n");
        } else if (operation.equals(MOVE)) {
            builder.append("From " + change.get(FROM).toString() + " \n");
            builder.append("To: " + path + " \n");
            builder.append("+++ " + newElement + " \n");
        } else {
            builder.append("+++ " + newElement + " \n");
            builder.append("--- " + oldElement + " \n");
        }
        return builder.toString();
    }

    private JsonNode getLeafOfJsonNode(String path, JsonNode jsonNode) {
        for (String pathElement : path.replace(BACKSLASH, EMPTY_STRING).substring(1).split(SLASH)) {
            jsonNode = this.isNumeric(pathElement) ? jsonNode.get(Integer.parseInt(pathElement)) : jsonNode.get(pathElement);
        }
        return jsonNode;
    }

    private boolean isNumeric(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

