/*
 * Decompiled with CFR 0.152.
 */
package org.japprove.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApprovalTestingConfiguration {
    private static final String APPROVAL_TESTING_PROPERTIES = "src" + File.separator + "test" + File.separator + "resources" + File.separator + "japprove.properties";
    private static final String DEFAULT_IDEA_DIFF = "C:" + File.separator + "Program Files" + File.separator + "JetBrains" + File.separator + "IntelliJ IDEA Community Edition 2019.2.3" + File.separator + "bin" + File.separator + "idea64 diff";
    private static final String DEFAULT_BASELINE_DIRECTORY = "baselines" + File.separator;
    private static final String DEFAULT_BASELINE_CANDIDATE_DIRECTORY = "build" + File.separator + "baselineCandidates" + File.separator;
    private static final Logger LOGGER = LogManager.getLogger(ApprovalTestingConfiguration.class);
    private String baselineDirectory;
    private String baselineCandidateDirectory;
    private String diffTool;

    public ApprovalTestingConfiguration() {
        this.loadProperties();
    }

    public String getBaselineDirectory() {
        return this.baselineDirectory;
    }

    public String getBaselineCandidateDirectory() {
        return this.baselineCandidateDirectory;
    }

    public String getDiffTool() {
        return this.diffTool;
    }

    private void loadProperties() {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(APPROVAL_TESTING_PROPERTIES));
            if (props.getProperty("baselineDirectory") == null) {
                this.baselineDirectory = DEFAULT_BASELINE_DIRECTORY;
            } else {
                String rawPath = props.getProperty("baselineDirectory");
                this.baselineDirectory = this.formatPath(rawPath);
            }
            this.baselineCandidateDirectory = props.getProperty("toApproveDirectory") == null ? DEFAULT_BASELINE_CANDIDATE_DIRECTORY : this.formatPath(props.getProperty("baselineCandidateDirectory"));
            this.diffTool = props.getProperty("diffTool") == null ? DEFAULT_IDEA_DIFF : this.adaptFileSeparatorsToOperatingSystem(props.getProperty("diffTool"));
            LOGGER.info("Loading properties from: " + APPROVAL_TESTING_PROPERTIES);
        }
        catch (IOException e) {
            this.baselineDirectory = DEFAULT_BASELINE_DIRECTORY;
            this.baselineCandidateDirectory = DEFAULT_BASELINE_CANDIDATE_DIRECTORY;
            this.diffTool = DEFAULT_IDEA_DIFF;
            LOGGER.info("Using default properties");
        }
    }

    private String formatPath(String path) {
        String formattedPath = this.adaptFileSeparatorsToOperatingSystem(path);
        formattedPath = this.ensureTrailingFileSeparatorExists(formattedPath);
        return formattedPath;
    }

    private String adaptFileSeparatorsToOperatingSystem(String path) {
        return path.replace("\\", File.separator).replace("/", File.separator);
    }

    private String ensureTrailingFileSeparatorExists(String path) {
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return path;
    }
}

