/*
 * Decompiled with CFR 0.152.
 */
package org.japprove.approver;

import java.util.List;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.japprove.differ.Differ;
import org.japprove.engine.ApprovalTestingEngine;
import org.japprove.exceptions.ApprovingFailedException;
import org.japprove.exceptions.BaselineCandidateNotFoundException;
import org.japprove.exceptions.BaselineCreationFailedException;
import org.japprove.exceptions.BaselineNotFoundException;
import org.japprove.exceptions.CopyingFailedException;
import org.japprove.repositories.BaselineRepositoryImpl;

public class Approver {
    private static final Logger LOGGER = LogManager.getLogger(Approver.class);
    private BaselineRepositoryImpl baselineRepository;
    private Differ differ;

    public Approver(ApprovalTestingEngine approvalTestingEngine) {
        this.baselineRepository = (BaselineRepositoryImpl)approvalTestingEngine.getBaselineRepository();
        this.differ = approvalTestingEngine.getDiffer();
    }

    public void approveBaselineCandidate(String name) {
        try {
            this.baselineRepository.copyBaselineCandidateToBaseline(name);
        }
        catch (BaselineCandidateNotFoundException e) {
            throw new ApprovingFailedException("Baseline candidate not found " + name);
        }
        catch (BaselineCreationFailedException e) {
            throw new ApprovingFailedException("Cannot create baseline " + name);
        }
        catch (CopyingFailedException e) {
            throw new ApprovingFailedException("Error while copying baseline candidate to baseline");
        }
        if (this.baselineRepository.removeBaselineCandidate(name)) {
            LOGGER.info("Successfully approved file " + name);
        }
    }

    public void approveAllBaselineCandidates() {
        List<String> baselineCandidateNames = this.baselineRepository.getBaselineCandidateNames();
        if (baselineCandidateNames.size() == 0) {
            LOGGER.info("Found no baseline candidates");
            return;
        }
        LOGGER.info("Found " + baselineCandidateNames.size() + " baseline candidates");
        for (String baselineCandidate : baselineCandidateNames) {
            this.approveBaselineCandidate(baselineCandidate);
        }
    }

    public void startApprovingBatchProcess() {
        List<String> baselineCandidateNames = this.baselineRepository.getBaselineCandidateNames();
        if (baselineCandidateNames.size() == 0) {
            LOGGER.info("Found no baseline candidates");
            return;
        }
        LOGGER.info("Found " + baselineCandidateNames.size() + " baseline candidates");
        LOGGER.info("Starting batch process ..");
        Scanner scanner = new Scanner(System.in);
        for (String baselineCandidate : baselineCandidateNames) {
            System.out.println("Baseline candidate: " + baselineCandidate);
            if (!this.baselineRepository.baselineExists(baselineCandidate)) {
                System.out.println("No baseline exists");
                System.out.println("Approve current version? (y/n)");
                if (!this.userAcceptsRequest(scanner)) continue;
                this.approveBaselineCandidate(baselineCandidate);
                continue;
            }
            try {
                System.out.println("Differences:\n" + this.baselineRepository.getDifferences(baselineCandidate));
            }
            catch (BaselineCandidateNotFoundException e) {
                throw new ApprovingFailedException("Baseline candidate not found " + baselineCandidate);
            }
            catch (BaselineNotFoundException e) {
                throw new ApprovingFailedException("Baseline not found " + baselineCandidate);
            }
            System.out.println("Show entire diff? (y/n)");
            if (this.userAcceptsRequest(scanner)) {
                this.differ.callExternalDiffTool(baselineCandidate);
            }
            System.out.println("Approve current version? (y/n)");
            if (!this.userAcceptsRequest(scanner)) continue;
            this.approveBaselineCandidate(baselineCandidate);
        }
        scanner.close();
    }

    private boolean userAcceptsRequest(Scanner scanner) {
        String input = scanner.next();
        while (!input.equals("y") && !input.equals("n")) {
            LOGGER.info("Wrong input!");
            input = scanner.next();
        }
        return input.equals("y");
    }
}

