/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.server;

import com.jcabi.manifests.Manifests;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.util.ServerGremlinExecutor;
import org.janusgraph.graphdb.grpc.JanusGraphContextHandler;
import org.janusgraph.graphdb.grpc.JanusGraphManagerServiceImpl;
import org.janusgraph.graphdb.grpc.schema.SchemaManagerImpl;
import org.janusgraph.graphdb.management.JanusGraphManager;
import org.janusgraph.graphdb.server.JanusGraphSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JanusGraphServer {
    private static final Logger logger = LoggerFactory.getLogger(JanusGraphServer.class);
    private GremlinServer gremlinServer = null;
    private JanusGraphSettings janusGraphSettings = null;
    private final String confPath;
    private CompletableFuture<Void> serverStarted = null;
    private CompletableFuture<Void> serverStopped = null;
    private Server grpcServer = null;
    public static final String MANIFEST_JANUSGRAPH_VERSION_ATTRIBUTE = "janusgraphVersion";
    public static final String MANIFEST_TINKERPOP_VERSION_ATTRIBUTE = "tinkerpopVersion";

    public JanusGraphServer(String file) {
        this.confPath = file;
    }

    public static void main(String[] args) {
        JanusGraphServer.printHeader();
        String file = args.length > 0 ? args[0] : "conf/janusgraph-server.yaml";
        JanusGraphServer janusGraphServer = new JanusGraphServer(file);
        ((CompletableFuture)janusGraphServer.start().exceptionally(t -> {
            logger.error("JanusGraph Server was unable to start and will now begin shutdown", t);
            janusGraphServer.stop().join();
            return null;
        })).join();
    }

    public GremlinServer getGremlinServer() {
        return this.gremlinServer;
    }

    public JanusGraphSettings getJanusGraphSettings() {
        return this.janusGraphSettings;
    }

    private Server createGrpcServer(JanusGraphSettings janusGraphSettings, GraphManager graphManager) {
        JanusGraphContextHandler janusGraphContextHandler = new JanusGraphContextHandler(graphManager);
        return ServerBuilder.forPort((int)janusGraphSettings.getGrpcServer().getPort()).addService((BindableService)new JanusGraphManagerServiceImpl(janusGraphContextHandler)).addService((BindableService)new SchemaManagerImpl(janusGraphContextHandler)).build();
    }

    public synchronized CompletableFuture<Void> start() {
        if (this.serverStarted != null) {
            return this.serverStarted;
        }
        this.serverStarted = new CompletableFuture();
        try {
            logger.info("Configuring JanusGraph Server from {}", (Object)this.confPath);
            this.janusGraphSettings = JanusGraphSettings.read(this.confPath);
            this.gremlinServer = new GremlinServer((Settings)this.janusGraphSettings);
            CompletableFuture<Object> grpcServerFuture = CompletableFuture.completedFuture(null);
            if (this.janusGraphSettings.getGrpcServer().isEnabled()) {
                grpcServerFuture = CompletableFuture.runAsync(() -> {
                    GraphManager graphManager = this.gremlinServer.getServerGremlinExecutor().getGraphManager();
                    this.grpcServer = this.createGrpcServer(this.janusGraphSettings, graphManager);
                    try {
                        this.grpcServer.start();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                });
            }
            CompletionStage gremlinServerFuture = this.gremlinServer.start().thenAcceptAsync(JanusGraphServer::configure);
            this.serverStarted = CompletableFuture.allOf(new CompletableFuture[]{gremlinServerFuture, grpcServerFuture});
        }
        catch (Exception ex) {
            this.serverStarted.completeExceptionally(ex);
        }
        return this.serverStarted;
    }

    private static void configure(ServerGremlinExecutor serverGremlinExecutor) {
        GraphManager graphManager = serverGremlinExecutor.getGraphManager();
        if (!(graphManager instanceof JanusGraphManager)) {
            return;
        }
        ((JanusGraphManager)graphManager).configureGremlinExecutor(serverGremlinExecutor.getGremlinExecutor());
    }

    public synchronized CompletableFuture<Void> stop() {
        if (this.gremlinServer == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.serverStopped != null) {
            return this.serverStopped;
        }
        if (this.grpcServer != null) {
            this.grpcServer.shutdownNow();
        }
        this.serverStopped = this.gremlinServer.stop();
        return this.serverStopped;
    }

    private static String getHeader() {
        return "                                                                      " + System.lineSeparator() + "   mmm                                mmm                       #     " + System.lineSeparator() + "     #   mmm   m mm   m   m   mmm   m\"   \"  m mm   mmm   mmmm   # mm  " + System.lineSeparator() + "     #  \"   #  #\"  #  #   #  #   \"  #   mm  #\"  \" \"   #  #\" \"#  #\"  # " + System.lineSeparator() + "     #  m\"\"\"#  #   #  #   #   \"\"\"m  #    #  #     m\"\"\"#  #   #  #   # " + System.lineSeparator() + " \"mmm\"  \"mm\"#  #   #  \"mm\"#  \"mmm\"   \"mmm\"  #     \"mm\"#  ##m#\"  #   # " + System.lineSeparator() + "                                                         #            " + System.lineSeparator() + "                                                         \"            " + System.lineSeparator();
    }

    private static void printHeader() {
        logger.info(JanusGraphServer.getHeader());
        logger.info("JanusGraph Version: {}", (Object)Manifests.read((String)MANIFEST_JANUSGRAPH_VERSION_ATTRIBUTE));
        logger.info("TinkerPop Version: {}", (Object)Manifests.read((String)MANIFEST_TINKERPOP_VERSION_ATTRIBUTE));
    }
}

