/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.server.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tinkerpop.gremlin.driver.ser.GraphBinaryMessageSerializerV1;
import org.apache.tinkerpop.gremlin.driver.ser.GraphSONMessageSerializerV3d0;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.util.DefaultGraphManager;
import org.janusgraph.graphdb.management.ConfigurationManagementGraph;
import org.janusgraph.graphdb.management.JanusGraphManager;
import org.janusgraph.graphdb.server.JanusGraphSettings;
import org.janusgraph.graphdb.tinkerpop.JanusGraphIoRegistry;

public class JanusGraphSettingsUtils {
    private static final String CONFIGURATION_MANAGEMENT_GRAPH_KEY = ConfigurationManagementGraph.class.getSimpleName();

    public static JanusGraphSettings configureDefaults(JanusGraphSettings settings) {
        return JanusGraphSettingsUtils.configureDefaultOfDynamicGraphs(JanusGraphSettingsUtils.configureDefaultSerializersIfNotSet(settings));
    }

    private static JanusGraphSettings configureDefaultOfDynamicGraphs(JanusGraphSettings settings) {
        if (!settings.graphs.containsKey(CONFIGURATION_MANAGEMENT_GRAPH_KEY)) {
            return settings;
        }
        if (settings.graphManager.equals(DefaultGraphManager.class.getName())) {
            settings.graphManager = JanusGraphManager.class.getCanonicalName();
        }
        return settings;
    }

    private static JanusGraphSettings configureDefaultSerializersIfNotSet(JanusGraphSettings settings) {
        if (settings.serializers.size() != 0) {
            return settings;
        }
        ArrayList<Settings.SerializerSettings> serializers = new ArrayList<Settings.SerializerSettings>();
        JanusGraphSettingsUtils.addSerializerWithRegistry(serializers, GraphBinaryMessageSerializerV1.class.getCanonicalName());
        JanusGraphSettingsUtils.addSerializerWithResultToString(serializers, GraphBinaryMessageSerializerV1.class.getCanonicalName());
        JanusGraphSettingsUtils.addSerializerWithRegistry(serializers, GraphSONMessageSerializerV3d0.class.getCanonicalName());
        settings.serializers = serializers;
        return settings;
    }

    private static void addSerializerWithRegistry(List<Settings.SerializerSettings> serializers, String className) {
        Settings.SerializerSettings newSerializerSettings = new Settings.SerializerSettings();
        newSerializerSettings.className = className;
        newSerializerSettings.config = Collections.singletonMap("ioRegistries", Collections.singletonList(JanusGraphIoRegistry.class.getCanonicalName()));
        serializers.add(newSerializerSettings);
    }

    private static void addSerializerWithResultToString(List<Settings.SerializerSettings> serializers, String className) {
        Settings.SerializerSettings newSerializerSettings = new Settings.SerializerSettings();
        newSerializerSettings.className = className;
        newSerializerSettings.config = Collections.singletonMap("serializeResultToString", true);
        serializers.add(newSerializerSettings);
    }
}

