/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.grpc.schema;

import io.grpc.Status;
import io.grpc.StatusException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.graphdb.grpc.schema.util.GrpcUtils;
import org.janusgraph.graphdb.grpc.types.EdgeLabel;
import org.janusgraph.graphdb.grpc.types.VertexCompositeGraphIndex;
import org.janusgraph.graphdb.grpc.types.VertexLabel;

public class SchemaManagerProvider {
    private final JanusGraphManagement management;

    public SchemaManagerProvider(JanusGraph graph) {
        this.management = graph.openManagement();
    }

    public VertexLabel getVertexLabelByName(String name) throws StatusException {
        org.janusgraph.core.VertexLabel vertexLabel = this.management.getVertexLabel(name);
        if (vertexLabel == null) {
            throw Status.NOT_FOUND.withDescription("No vertexLabel found with name: " + name).asException();
        }
        return GrpcUtils.createVertexLabelProto(vertexLabel);
    }

    public List<VertexLabel> getVertexLabels() {
        return StreamSupport.stream(this.management.getVertexLabels().spliterator(), false).map(GrpcUtils::createVertexLabelProto).collect(Collectors.toList());
    }

    public EdgeLabel getEdgeLabelByName(String name) throws StatusException {
        org.janusgraph.core.EdgeLabel edgeLabel = this.management.getEdgeLabel(name);
        if (edgeLabel == null) {
            throw Status.NOT_FOUND.withDescription("No edgeLabel found with name: " + name).asException();
        }
        return GrpcUtils.createEdgeLabelProto(edgeLabel);
    }

    public List<EdgeLabel> getEdgeLabels() {
        return StreamSupport.stream(this.management.getRelationTypes(org.janusgraph.core.EdgeLabel.class).spliterator(), false).map(GrpcUtils::createEdgeLabelProto).collect(Collectors.toList());
    }

    public VertexCompositeGraphIndex getVertexCompositeGraphIndexByName(String indexName) throws StatusException {
        JanusGraphIndex graphIndex = this.management.getGraphIndex(indexName);
        if (graphIndex == null) {
            throw Status.NOT_FOUND.withDescription("No composite graph index found with name: " + indexName).asException();
        }
        if (!graphIndex.isCompositeIndex()) {
            throw Status.FAILED_PRECONDITION.withDescription("Graph index isn't a composite index with name: " + indexName).asException();
        }
        if (!Vertex.class.isAssignableFrom(graphIndex.getIndexedElement())) {
            throw Status.FAILED_PRECONDITION.withDescription("Composite graph index isn't assignable to a vertex with name: " + indexName).asException();
        }
        return GrpcUtils.createVertexCompositeGraphIndex(graphIndex);
    }

    public List<VertexCompositeGraphIndex> getVertexCompositeGraphIndices() {
        Iterable indices = this.management.getGraphIndexes(Vertex.class);
        return StreamSupport.stream(indices.spliterator(), false).filter(JanusGraphIndex::isCompositeIndex).map(GrpcUtils::createVertexCompositeGraphIndex).collect(Collectors.toList());
    }
}

