/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.grpc.schema;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.graphdb.grpc.schema.util.GrpcUtils;
import org.janusgraph.graphdb.grpc.types.EdgeLabel;
import org.janusgraph.graphdb.grpc.types.VertexLabel;

public class SchemaManagerProvider {
    private final JanusGraphManagement management;

    public SchemaManagerProvider(JanusGraph graph) {
        this.management = graph.openManagement();
    }

    public VertexLabel getVertexLabelByName(String name) {
        org.janusgraph.core.VertexLabel vertexLabel = this.management.getVertexLabel(name);
        if (vertexLabel == null) {
            return null;
        }
        return GrpcUtils.createVertexLabelProto(vertexLabel);
    }

    public List<VertexLabel> getVertexLabels() {
        return StreamSupport.stream(this.management.getVertexLabels().spliterator(), false).map(GrpcUtils::createVertexLabelProto).collect(Collectors.toList());
    }

    public EdgeLabel getEdgeLabelByName(String name) {
        org.janusgraph.core.EdgeLabel edgeLabel = this.management.getEdgeLabel(name);
        if (edgeLabel == null) {
            return null;
        }
        return GrpcUtils.createEdgeLabelProto(edgeLabel);
    }

    public List<EdgeLabel> getEdgeLabels() {
        return StreamSupport.stream(this.management.getRelationTypes(org.janusgraph.core.EdgeLabel.class).spliterator(), false).map(GrpcUtils::createEdgeLabelProto).collect(Collectors.toList());
    }
}

