/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.grpc;

import java.util.ArrayList;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.graphdb.grpc.schema.SchemaManagerProvider;
import org.janusgraph.graphdb.grpc.types.JanusGraphContext;

public class JanusGraphContextHandler {
    private final GraphManager graphManager;

    public JanusGraphContextHandler(GraphManager graphManager) {
        this.graphManager = graphManager;
    }

    public Iterable<JanusGraphContext> getContexts() {
        ArrayList<JanusGraphContext> contexts = new ArrayList<JanusGraphContext>();
        for (String graphName : this.graphManager.getGraphNames()) {
            Graph graph = this.graphManager.getGraph(graphName);
            if (!(graph instanceof JanusGraph)) continue;
            contexts.add(JanusGraphContext.newBuilder().setGraphName(graphName).build());
        }
        return contexts;
    }

    public JanusGraphContext getContextByGraphName(String graphName) {
        Graph graph = this.graphManager.getGraph(graphName);
        if (!(graph instanceof JanusGraph)) {
            return null;
        }
        return JanusGraphContext.newBuilder().setGraphName(graphName).build();
    }

    public SchemaManagerProvider getSchemaManagerProviderByContext(JanusGraphContext context) {
        Graph graph = this.graphManager.getGraph(context.getGraphName());
        if (!(graph instanceof JanusGraph)) {
            return null;
        }
        return new SchemaManagerProvider((JanusGraph)graph);
    }
}

