/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.grpc.schema;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.List;
import org.janusgraph.graphdb.grpc.JanusGraphContextHandler;
import org.janusgraph.graphdb.grpc.schema.GetEdgeLabelByNameRequest;
import org.janusgraph.graphdb.grpc.schema.GetEdgeLabelByNameResponse;
import org.janusgraph.graphdb.grpc.schema.GetEdgeLabelsRequest;
import org.janusgraph.graphdb.grpc.schema.GetEdgeLabelsResponse;
import org.janusgraph.graphdb.grpc.schema.GetVertexLabelByNameRequest;
import org.janusgraph.graphdb.grpc.schema.GetVertexLabelByNameResponse;
import org.janusgraph.graphdb.grpc.schema.GetVertexLabelsRequest;
import org.janusgraph.graphdb.grpc.schema.GetVertexLabelsResponse;
import org.janusgraph.graphdb.grpc.schema.SchemaManagerProvider;
import org.janusgraph.graphdb.grpc.schema.SchemaManagerServiceGrpc;
import org.janusgraph.graphdb.grpc.types.EdgeLabel;
import org.janusgraph.graphdb.grpc.types.JanusGraphContext;
import org.janusgraph.graphdb.grpc.types.VertexLabel;

public class SchemaManagerImpl
extends SchemaManagerServiceGrpc.SchemaManagerServiceImplBase {
    private final JanusGraphContextHandler contextHandler;

    public SchemaManagerImpl(JanusGraphContextHandler contextHandler) {
        this.contextHandler = contextHandler;
    }

    private SchemaManagerProvider getSchemaManagerProvider(JanusGraphContext context, ErrorFunction errorFunction) {
        if (context == null) {
            errorFunction.run((Throwable)Status.INVALID_ARGUMENT.withDescription("context is required").asException());
            return null;
        }
        SchemaManagerProvider provider = this.contextHandler.getSchemaManagerProviderByContext(context);
        if (provider == null) {
            errorFunction.run((Throwable)Status.INVALID_ARGUMENT.withDescription("a schema manager provider was not found with the provided context").asException());
            return null;
        }
        return provider;
    }

    public void getVertexLabelByName(GetVertexLabelByNameRequest request, StreamObserver<GetVertexLabelByNameResponse> responseObserver) {
        SchemaManagerProvider provider = this.getSchemaManagerProvider(request.getContext(), arg_0 -> responseObserver.onError(arg_0));
        if (provider == null) {
            return;
        }
        String vertexLabelName = request.getName();
        if (vertexLabelName.isEmpty()) {
            responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("name is required").asException());
            return;
        }
        VertexLabel vertexLabel = provider.getVertexLabelByName(vertexLabelName);
        if (vertexLabel == null) {
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription("No vertexLabel found with name: " + vertexLabelName).asException());
            return;
        }
        responseObserver.onNext((Object)GetVertexLabelByNameResponse.newBuilder().setVertexLabel(vertexLabel).build());
        responseObserver.onCompleted();
    }

    public void getVertexLabels(GetVertexLabelsRequest request, StreamObserver<GetVertexLabelsResponse> responseObserver) {
        SchemaManagerProvider provider = this.getSchemaManagerProvider(request.getContext(), arg_0 -> responseObserver.onError(arg_0));
        if (provider == null) {
            return;
        }
        List<VertexLabel> vertexLabels = provider.getVertexLabels();
        responseObserver.onNext((Object)GetVertexLabelsResponse.newBuilder().addAllVertexLabels(vertexLabels).build());
        responseObserver.onCompleted();
    }

    public void getEdgeLabelByName(GetEdgeLabelByNameRequest request, StreamObserver<GetEdgeLabelByNameResponse> responseObserver) {
        SchemaManagerProvider provider = this.getSchemaManagerProvider(request.getContext(), arg_0 -> responseObserver.onError(arg_0));
        if (provider == null) {
            return;
        }
        String edgeLabelName = request.getName();
        if (edgeLabelName.isEmpty()) {
            responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("name is required").asException());
            return;
        }
        EdgeLabel edgeLabel = provider.getEdgeLabelByName(edgeLabelName);
        if (edgeLabel == null) {
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription("No edgeLabel found with name: " + edgeLabelName).asException());
            return;
        }
        responseObserver.onNext((Object)GetEdgeLabelByNameResponse.newBuilder().setEdgeLabel(edgeLabel).build());
        responseObserver.onCompleted();
    }

    public void getEdgeLabels(GetEdgeLabelsRequest request, StreamObserver<GetEdgeLabelsResponse> responseObserver) {
        SchemaManagerProvider provider = this.getSchemaManagerProvider(request.getContext(), arg_0 -> responseObserver.onError(arg_0));
        if (provider == null) {
            return;
        }
        List<EdgeLabel> edgeLabels = provider.getEdgeLabels();
        responseObserver.onNext((Object)GetEdgeLabelsResponse.newBuilder().addAllEdgeLabels(edgeLabels).build());
        responseObserver.onCompleted();
    }

    static interface ErrorFunction {
        public void run(Throwable var1);
    }
}

