/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.inmemory;

import com.google.common.base.Preconditions;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.inmemory.BufferPage;
import org.janusgraph.diskstorage.inmemory.BufferPageUtils;
import org.janusgraph.diskstorage.inmemory.MemoryEntryList;
import org.janusgraph.diskstorage.inmemory.SharedEntryBuffer;
import org.janusgraph.diskstorage.inmemory.SharedEntryBufferFragmentationReport;
import org.janusgraph.diskstorage.inmemory.SinglePageEntryBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPageEntryBuffer
implements SharedEntryBuffer {
    private static int INITIAL_CAPACITY = 2;
    private static final Logger log = LoggerFactory.getLogger(BufferPageUtils.class);
    private ArrayList<BufferPage> pages;

    public MultiPageEntryBuffer(BufferPage initialPage) {
        this.pages = new ArrayList(INITIAL_CAPACITY);
        if (initialPage instanceof SinglePageEntryBuffer) {
            this.pages.add(new BufferPage(initialPage.getOffsetIndex(), initialPage.getRawData()));
        } else {
            this.pages.add(initialPage);
        }
    }

    MultiPageEntryBuffer(List<BufferPage> allPages) {
        this.pages = new ArrayList<BufferPage>(allPages);
    }

    @Override
    public int numPages() {
        return this.pages.size();
    }

    @Override
    public int numEntries() {
        if (this.pages == null) {
            return 0;
        }
        int numEntries = 0;
        for (BufferPage p : this.pages) {
            numEntries += p.numEntries();
        }
        return numEntries;
    }

    @Override
    public int byteSize() {
        if (this.pages == null) {
            return 0;
        }
        int byteSize = 0;
        for (BufferPage p : this.pages) {
            byteSize += p.byteSize() + 16;
        }
        return byteSize;
    }

    @Override
    public boolean isEmpty() {
        return this.pages.isEmpty();
    }

    private int getPageIndex(StaticBuffer column) {
        int low = 0;
        int high = this.pages.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            BufferPage midPage = this.pages.get(mid);
            int idx = midPage.getIndex(column);
            if (idx >= 0) {
                return mid;
            }
            if ((idx = -idx - 1) <= 0) {
                high = mid - 1;
                continue;
            }
            if (idx >= midPage.numEntries()) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public EntryList getSlice(KeySliceQuery query) {
        int endPageLimit;
        if (this.pages == null || this.pages.size() == 0) {
            return EntryList.EMPTY_LIST;
        }
        int startPageIdx = this.getPageIndex(query.getSliceStart());
        if (startPageIdx < 0) {
            startPageIdx = -startPageIdx - 1;
        }
        endPageLimit = (endPageLimit = this.getPageIndex(query.getSliceEnd())) < 0 ? -endPageLimit - 1 : ++endPageLimit;
        if (startPageIdx < endPageLimit) {
            int endIndex;
            int startIndex = this.pages.get(startPageIdx).getIndex(query.getSliceStart());
            if (startIndex < 0) {
                startIndex = -startIndex - 1;
            }
            if ((endIndex = this.pages.get(endPageLimit - 1).getIndex(query.getSliceEnd())) < 0) {
                endIndex = -endIndex - 1;
            }
            MemoryEntryList result = new MemoryEntryList(0);
            for (int i = startPageIdx; !(i >= endPageLimit || query.hasLimit() && result.size() >= query.getLimit()); ++i) {
                BufferPage page = this.pages.get(i);
                int start = i == startPageIdx ? startIndex : 0;
                int end = i == endPageLimit - 1 ? endIndex : page.numEntries();
                for (int j = start; !(j >= end || query.hasLimit() && result.size() >= query.getLimit()); ++j) {
                    result.add(page.getNoCopy(j));
                }
            }
            return result;
        }
        return EntryList.EMPTY_LIST;
    }

    @Override
    public void mutate(Entry[] add, Entry[] del, int maxPageSize) {
        int pageHits = 0;
        int oldPageCount = this.pages.size();
        if (this.pages.size() == 0) {
            this.pages.add(BufferPageUtils.buildFromEntryArray(new Entry[0], 0));
        }
        int iadd = 0;
        int idel = 0;
        int currPageNo = 0;
        while (currPageNo < this.pages.size() && (iadd < add.length || idel < del.length)) {
            BufferPage currPage = this.pages.get(currPageNo);
            BufferPage nextPage = currPageNo + 1 < this.pages.size() ? this.pages.get(currPageNo + 1) : null;
            Preconditions.checkArgument((nextPage == null || nextPage.numEntries() > 0 ? 1 : 0) != 0);
            Entry nextPageStart = nextPage == null ? null : nextPage.getNoCopy(0);
            boolean pageNeedsMerging = false;
            if (iadd < add.length) {
                boolean bl = pageNeedsMerging = nextPageStart == null;
                if (!pageNeedsMerging) {
                    int compare = nextPageStart.compareTo((Object)add[iadd]);
                    boolean bl2 = pageNeedsMerging = compare >= 0;
                }
            }
            if (!pageNeedsMerging && idel < del.length) {
                Entry thisPageEnd = currPage.getNoCopy(currPage.numEntries() - 1);
                int compare = thisPageEnd.compareTo((Object)del[idel]);
                boolean bl = pageNeedsMerging = compare >= 0;
            }
            if (pageNeedsMerging) {
                int delLimit;
                int addLimit;
                if (nextPageStart == null) {
                    addLimit = add.length;
                    delLimit = del.length;
                } else {
                    for (addLimit = iadd; addLimit < add.length && nextPageStart.compareTo((Object)add[addLimit]) > 0; ++addLimit) {
                    }
                    for (delLimit = idel; delLimit < del.length && nextPageStart.compareTo((Object)del[delLimit]) > 0; ++delLimit) {
                    }
                }
                List<BufferPage> mergedPages = currPage.merge(add, iadd, addLimit, del, idel, delLimit, maxPageSize);
                if (mergedPages.size() == 0) {
                    this.pages.remove(currPageNo);
                } else {
                    this.pages.set(currPageNo, mergedPages.get(0));
                    ++currPageNo;
                    if (mergedPages.size() > 1) {
                        mergedPages.remove(0);
                        this.pages.addAll(currPageNo, mergedPages);
                        currPageNo += mergedPages.size();
                        pageHits += mergedPages.size();
                    }
                }
                iadd = addLimit;
                idel = delLimit;
                ++pageHits;
                continue;
            }
            ++currPageNo;
        }
        if (oldPageCount >= this.pages.size()) {
            this.pages.trimToSize();
        }
    }

    @Override
    public boolean isPaged() {
        return true;
    }

    @Override
    public SharedEntryBufferFragmentationReport createFragmentationReport(int maxPageSize) {
        SharedEntryBufferFragmentationReport.Builder report = new SharedEntryBufferFragmentationReport.Builder();
        report.pageCount(this.pages.size());
        if (this.pages.size() < 2) {
            return report.build();
        }
        int compressableChunksCount = 0;
        int fragmentedPageCount = 0;
        int currCompressableCount = 0;
        int totalCompressableCount = 0;
        int currChunkNumEntries = 0;
        int achievablePageReduction = 0;
        for (BufferPage page : this.pages) {
            if (page.numEntries() < maxPageSize) {
                ++fragmentedPageCount;
                ++currCompressableCount;
                currChunkNumEntries += page.numEntries();
                continue;
            }
            int numPagesAfterCompression = this.getNumPagesRequired(currChunkNumEntries, maxPageSize);
            if (numPagesAfterCompression < currCompressableCount) {
                ++compressableChunksCount;
                totalCompressableCount += currCompressableCount;
                achievablePageReduction += currCompressableCount - numPagesAfterCompression;
            }
            currCompressableCount = 0;
            currChunkNumEntries = 0;
        }
        if (currCompressableCount > 1) {
            ++compressableChunksCount;
            totalCompressableCount += currCompressableCount;
            achievablePageReduction += currCompressableCount - this.getNumPagesRequired(currChunkNumEntries, maxPageSize);
        }
        return report.fragmentedPageCount(fragmentedPageCount).compressableChunksCount(compressableChunksCount).compressablePageCount(totalCompressableCount).achievablePageReduction(achievablePageReduction).build();
    }

    @Override
    public void quickDefragment(int maxPageSize) {
        ArrayList<BufferPage> currChunkToDefragment = new ArrayList<BufferPage>();
        int currChunkStart = -1;
        int currChunkNumEntries = 0;
        for (int i = 0; i < this.pages.size(); ++i) {
            BufferPage page = this.pages.get(i);
            if (page.numEntries() < maxPageSize) {
                if (currChunkStart < 0) {
                    currChunkStart = i;
                }
                currChunkNumEntries += page.numEntries();
                currChunkToDefragment.add(page);
                continue;
            }
            if (currChunkToDefragment.size() > 1 && this.getNumPagesRequired(currChunkNumEntries, maxPageSize) < currChunkToDefragment.size()) {
                this.defragmentAndReplaceChunk(maxPageSize, currChunkToDefragment, currChunkStart);
            }
            currChunkToDefragment.clear();
            currChunkStart = -1;
            currChunkNumEntries = 0;
        }
        if (currChunkToDefragment.size() > 1 && this.getNumPagesRequired(currChunkNumEntries, maxPageSize) < currChunkToDefragment.size()) {
            this.defragmentAndReplaceChunk(maxPageSize, currChunkToDefragment, currChunkStart);
        }
    }

    @Override
    public void dumpTo(DataOutputStream out) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("number of pages in multipage buffer is " + this.numPages());
        }
        out.writeInt(this.numPages());
        for (BufferPage page : this.pages) {
            BufferPageUtils.dumpTo(page, out);
        }
    }

    private int getNumPagesRequired(int currChunkNumEntries, int maxPageSize) {
        return currChunkNumEntries / maxPageSize + (currChunkNumEntries % maxPageSize > 0 ? 1 : 0);
    }

    private void defragmentAndReplaceChunk(int maxPageSize, List<BufferPage> currChunkToDefragment, int currChunkStart) {
        List<BufferPage> mergedPages = BufferPage.merge(currChunkToDefragment, maxPageSize);
        for (int j = currChunkToDefragment.size() - 1; j >= 0; --j) {
            this.pages.remove(currChunkStart + j);
        }
        this.pages.addAll(currChunkStart, mergedPages);
    }
}

