/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.janusgraph.HBaseContainer;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.hadoop.AbstractInputFormatIT;
import org.janusgraph.util.system.ConfigurationUtil;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class HBaseInputFormatIT
extends AbstractInputFormatIT {
    @Container
    private static final HBaseContainer hbase = new HBaseContainer();

    private PropertiesConfiguration getGraphConfiguration(String filename) throws ConfigurationException, IOException {
        PropertiesConfiguration config = ConfigurationUtil.loadPropertiesConfig((String)filename, (boolean)false);
        Path baseOutDir = Paths.get((String)config.getProperty("gremlin.hadoop.outputLocation"), new String[0]);
        baseOutDir.toFile().mkdirs();
        String outDir = Files.createTempDirectory(baseOutDir, null, new FileAttribute[0]).toAbsolutePath().toString();
        config.setProperty("gremlin.hadoop.outputLocation", (Object)outDir);
        return config;
    }

    public WriteConfiguration getConfiguration() {
        return hbase.getWriteConfiguration();
    }

    protected Graph getGraph() throws ConfigurationException, IOException {
        return GraphFactory.open((Configuration)this.getGraphConfiguration("target/test-classes/hbase-read.properties"));
    }
}

