/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.hbase;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.appender.WriterAppender;
import org.apache.logging.log4j.core.filter.LevelMatchFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.janusgraph.HBaseContainer;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.common.DistributedStoreManager;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.hbase.HBaseStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.util.time.TimestampProviders;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.configuration.builder.GraphDatabaseConfigurationBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class HBaseStoreManagerConfigTest {
    @Container
    public static final HBaseContainer hBaseContainer = new HBaseContainer();

    @Test
    public void testShortCfNames() throws Exception {
        Logger log = (Logger)LogManager.getLogger(HBaseStoreManager.class);
        StringWriter writer = new StringWriter();
        WriterAppender appender = WriterAppender.createAppender((StringLayout)PatternLayout.newBuilder().withPattern("%p: %m%n").build(), (Filter)LevelMatchFilter.newBuilder().setLevel(Level.WARN).build(), (Writer)writer, (String)"test", (boolean)false, (boolean)false);
        appender.start();
        log.addAppender((Appender)appender);
        WriteConfiguration config = hBaseContainer.getWriteConfiguration();
        HBaseStoreManager manager = new HBaseStoreManager((Configuration)new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, (ReadConfiguration)config, BasicConfiguration.Restriction.NONE));
        KeyColumnValueStore store = manager.openDatabase("system_properties");
        store.close();
        manager.close();
        config.set(ConfigElement.getPath((ConfigElement)HBaseStoreManager.SHORT_CF_NAMES, (String[])new String[0]), (Object)false);
        manager = new HBaseStoreManager((Configuration)new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, (ReadConfiguration)config, BasicConfiguration.Restriction.NONE));
        writer.getBuffer().setLength(0);
        store = manager.openDatabase("system_properties");
        Assertions.assertTrue((boolean)writer.toString().startsWith("WARN: Configuration"), (String)writer.toString());
        log.removeAppender((Appender)appender);
        store.close();
        manager.close();
    }

    @Test
    public void testHBaseTimestampProvider() {
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildGraphConfiguration();
        config.set(GraphDatabaseConfiguration.STORAGE_BACKEND, (Object)"hbase", new String[0]);
        GraphDatabaseConfiguration graphConfig = new GraphDatabaseConfigurationBuilder().build((ReadConfiguration)config.getConfiguration());
        TimestampProviders provider = (TimestampProviders)graphConfig.getConfiguration().get(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, new String[0]);
        Assertions.assertEquals((Object)HBaseStoreManager.PREFERRED_TIMESTAMPS, (Object)provider);
    }

    @Test
    public void testHBaseStoragePort() throws BackendException {
        WriteConfiguration config = hBaseContainer.getWriteConfiguration();
        config.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.STORAGE_PORT, (String[])new String[0]), (Object)2000);
        HBaseStoreManager manager = new HBaseStoreManager((Configuration)new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, (ReadConfiguration)config, BasicConfiguration.Restriction.NONE));
        String port = manager.getHBaseConf().get("hbase.zookeeper.property.clientPort");
        Assertions.assertEquals((Object)"2000", (Object)port);
    }

    @Test
    public void testHBaseSkipSchemaCheck() throws Exception {
        Logger log = (Logger)LogManager.getLogger(HBaseStoreManager.class);
        Level savedLevel = log.getLevel();
        log.setLevel(Level.DEBUG);
        StringWriter writer = new StringWriter();
        WriterAppender appender = WriterAppender.createAppender((StringLayout)PatternLayout.newBuilder().withPattern("%p: %m%n").build(), (Filter)LevelMatchFilter.newBuilder().setLevel(Level.DEBUG).build(), (Writer)writer, (String)"test", (boolean)false, (boolean)false);
        appender.start();
        log.addAppender((Appender)appender);
        WriteConfiguration config = hBaseContainer.getWriteConfiguration();
        HBaseStoreManager manager = new HBaseStoreManager((Configuration)new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, (ReadConfiguration)config, BasicConfiguration.Restriction.NONE));
        Assertions.assertEquals((Object)manager.getDeployment(), (Object)DistributedStoreManager.Deployment.REMOTE);
        Assertions.assertTrue((boolean)writer.toString().contains("Performing schema check"), (String)writer.toString());
        manager.close();
        config.set(ConfigElement.getPath((ConfigElement)HBaseStoreManager.SKIP_SCHEMA_CHECK, (String[])new String[0]), (Object)true);
        manager = new HBaseStoreManager((Configuration)new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, (ReadConfiguration)config, BasicConfiguration.Restriction.NONE));
        writer.getBuffer().setLength(0);
        Assertions.assertEquals((Object)manager.getDeployment(), (Object)DistributedStoreManager.Deployment.REMOTE);
        Assertions.assertTrue((boolean)writer.toString().contains("Skipping schema check"), (String)writer.toString());
        log.removeAppender((Appender)appender);
        log.setLevel(savedLevel);
        config.set(ConfigElement.getPath((ConfigElement)HBaseStoreManager.HBASE_TABLE, (String[])new String[0]), (Object)"unknown_table");
        HBaseStoreManager skipSchemaManager = new HBaseStoreManager((Configuration)new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, (ReadConfiguration)config, BasicConfiguration.Restriction.NONE));
        Exception ex = (Exception)Assertions.assertThrows(PermanentBackendException.class, () -> skipSchemaManager.getLocalKeyPartition());
        Assertions.assertEquals((Object)"Table unknown_table doesn't exist in HBase!", (Object)ex.getMessage());
        manager.close();
    }
}

