/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.tinkerpop.gremlin.process.computer.Computer;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.spark.process.computer.SparkGraphComputer;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.janusgraph.HBaseContainer;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.example.GraphOfTheGodsFactory;
import org.janusgraph.hadoop.AbstractInputFormatIT;
import org.janusgraph.util.system.ConfigurationUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class HBaseSnapshotInputFormatIT
extends AbstractInputFormatIT {
    @Container
    public static final HBaseContainer hBaseContainer = new HBaseContainer(true);
    private final String table = "janusgraph";
    private final String snapshotName = "janusgraph-snapshot";

    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        hBaseContainer.deleteSnapshot("janusgraph-snapshot");
    }

    @Test
    public void testReadGraphOfTheGods() throws Exception {
        GraphOfTheGodsFactory.load((JanusGraph)this.graph, null, (boolean)true);
        Assertions.assertEquals((long)12L, (long)((Long)this.graph.traversal().V(new Object[0]).count().next()));
        hBaseContainer.createSnapshot("janusgraph-snapshot", "janusgraph");
        Graph g = this.getGraph();
        GraphTraversalSource t = g.traversal().withComputer(SparkGraphComputer.class);
        Assertions.assertEquals((long)12L, (long)((Long)t.V(new Object[0]).count().next()));
    }

    @Test
    public void testReadWideVertexWithManyProperties() throws Exception {
        int i;
        int numProps = 65536;
        long numV = 1L;
        this.mgmt.makePropertyKey("p").cardinality(Cardinality.LIST).dataType(Integer.class).make();
        this.mgmt.commit();
        this.finishSchema();
        int j = 0;
        while ((long)j < numV) {
            JanusGraphVertex v = this.graph.addVertex(new Object[0]);
            for (i = 0; i < numProps; ++i) {
                v.property("p", (Object)i);
            }
            ++j;
        }
        this.graph.tx().commit();
        Assertions.assertEquals((long)numV, (long)((Long)this.graph.traversal().V(new Object[0]).count().next()));
        Map propertiesOnVertex = (Map)this.graph.traversal().V(new Object[0]).valueMap(new String[0]).next();
        List valuesOnP = (List)propertiesOnVertex.values().iterator().next();
        Assertions.assertEquals((int)numProps, (int)valuesOnP.size());
        for (i = 0; i < numProps; ++i) {
            Assertions.assertEquals((Object)Integer.toString(i), (Object)valuesOnP.get(i).toString());
        }
        hBaseContainer.createSnapshot("janusgraph-snapshot", "janusgraph");
        Graph g = this.getGraph();
        GraphTraversalSource t = g.traversal().withComputer(SparkGraphComputer.class);
        Assertions.assertEquals((long)numV, (long)((Long)t.V(new Object[0]).count().next()));
        propertiesOnVertex = (Map)t.V(new Object[0]).valueMap(new String[0]).next();
        Set observedValuesOnP = Collections.unmodifiableSet(new HashSet((List)propertiesOnVertex.values().iterator().next()));
        Assertions.assertEquals((int)numProps, (int)observedValuesOnP.size());
        Assertions.assertEquals(Collections.unmodifiableSet(new HashSet(valuesOnP)), observedValuesOnP, (String)"Unexpected values");
    }

    @Test
    public void testReadSelfEdge() throws Exception {
        GraphOfTheGodsFactory.load((JanusGraph)this.graph, null, (boolean)true);
        Assertions.assertEquals((long)12L, (long)((Long)this.graph.traversal().V(new Object[0]).count().next()));
        JanusGraphVertex sky = (JanusGraphVertex)this.graph.query().has("name", (Object)"sky").vertices().iterator().next();
        Assertions.assertNotNull((Object)sky);
        Assertions.assertEquals((Object)"sky", (Object)sky.value("name"));
        Assertions.assertEquals((long)1L, (long)sky.query().direction(Direction.IN).edgeCount());
        Assertions.assertEquals((long)0L, (long)sky.query().direction(Direction.OUT).edgeCount());
        Assertions.assertEquals((long)1L, (long)sky.query().direction(Direction.BOTH).edgeCount());
        sky.addEdge("lives", (Vertex)sky, new Object[]{"reason", "testReadSelfEdge"});
        Assertions.assertEquals((long)2L, (long)sky.query().direction(Direction.IN).edgeCount());
        Assertions.assertEquals((long)1L, (long)sky.query().direction(Direction.OUT).edgeCount());
        Assertions.assertEquals((long)3L, (long)sky.query().direction(Direction.BOTH).edgeCount());
        this.graph.tx().commit();
        hBaseContainer.createSnapshot("janusgraph-snapshot", "janusgraph");
        Graph g = this.getGraph();
        GraphTraversalSource t = g.traversal().withComputer(SparkGraphComputer.class);
        GraphTraversal edgeIdIter = t.V(new Object[0]).has("name", (Object)"sky").bothE(new String[0]).id();
        Assertions.assertNotNull((Object)edgeIdIter);
        Assertions.assertTrue((boolean)edgeIdIter.hasNext());
        HashSet edges = new HashSet();
        edgeIdIter.forEachRemaining(edges::add);
        Assertions.assertEquals((int)2, (int)edges.size());
    }

    @Test
    public void testReadMultipleSelfEdges() throws Exception {
        GraphOfTheGodsFactory.load((JanusGraph)this.graph, null, (boolean)true);
        Assertions.assertEquals((long)12L, (long)((Long)this.graph.traversal().V(new Object[0]).count().next()));
        JanusGraphVertex sky = (JanusGraphVertex)this.graph.query().has("name", (Object)"sky").vertices().iterator().next();
        Assertions.assertNotNull((Object)sky);
        Assertions.assertEquals((Object)"sky", (Object)sky.value("name"));
        Assertions.assertEquals((long)1L, (long)sky.query().direction(Direction.IN).edgeCount());
        Assertions.assertEquals((long)0L, (long)sky.query().direction(Direction.OUT).edgeCount());
        Assertions.assertEquals((long)1L, (long)sky.query().direction(Direction.BOTH).edgeCount());
        sky.addEdge("lives", (Vertex)sky, new Object[]{"reason", "testReadMultipleSelfEdges1"});
        sky.addEdge("lives", (Vertex)sky, new Object[]{"reason", "testReadMultipleSelfEdges2"});
        sky.addEdge("lives", (Vertex)sky, new Object[]{"reason", "testReadMultipleSelfEdges3"});
        Assertions.assertEquals((long)4L, (long)sky.query().direction(Direction.IN).edgeCount());
        Assertions.assertEquals((long)3L, (long)sky.query().direction(Direction.OUT).edgeCount());
        Assertions.assertEquals((long)7L, (long)sky.query().direction(Direction.BOTH).edgeCount());
        this.graph.tx().commit();
        hBaseContainer.createSnapshot("janusgraph-snapshot", "janusgraph");
        Graph g = this.getGraph();
        GraphTraversalSource t = g.traversal().withComputer(SparkGraphComputer.class);
        GraphTraversal edgeIdIterator = t.V(new Object[0]).has("name", (Object)"sky").bothE(new String[0]).id();
        Assertions.assertNotNull((Object)edgeIdIterator);
        Assertions.assertTrue((boolean)edgeIdIterator.hasNext());
        HashSet edges = new HashSet();
        edgeIdIterator.forEachRemaining(edges::add);
        Assertions.assertEquals((int)4, (int)edges.size());
    }

    @Test
    public void testGeoshapeGetValues() throws Exception {
        GraphOfTheGodsFactory.load((JanusGraph)this.graph, null, (boolean)true);
        hBaseContainer.createSnapshot("janusgraph-snapshot", "janusgraph");
        Graph g = this.getGraph();
        GraphTraversalSource t = g.traversal().withComputer(SparkGraphComputer.class);
        GraphTraversal geoIter = t.E(new Object[0]).values(new String[]{"place"});
        Assertions.assertNotNull((Object)geoIter);
        Assertions.assertTrue((boolean)geoIter.hasNext());
        HashSet geos = new HashSet();
        geoIter.forEachRemaining(geos::add);
        Assertions.assertEquals((int)3, (int)geos.size());
    }

    @Test
    public void testReadGraphOfTheGodsWithEdgeFiltering() throws Exception {
        GraphOfTheGodsFactory.load((JanusGraph)this.graph, null, (boolean)true);
        Assertions.assertEquals((long)17L, (long)((Long)this.graph.traversal().E(new Object[0]).count().next()));
        hBaseContainer.createSnapshot("janusgraph-snapshot", "janusgraph");
        Graph g = this.getGraph();
        Computer computer = Computer.compute(SparkGraphComputer.class).edges((Traversal)__.bothE((String[])new String[0]).hasLabel(P.neq((Object)"battled")));
        GraphTraversalSource t = g.traversal().withComputer(computer);
        Assertions.assertEquals((long)14L, (long)((Long)t.E(new Object[0]).count().next()));
    }

    @Test
    public void testGraphWithIsolatedVertices() throws Exception {
        String key = "vertexKey";
        this.graph.addVertex(key);
        this.graph.tx().commit();
        hBaseContainer.createSnapshot("janusgraph-snapshot", "janusgraph");
        Graph g = this.getGraph();
        GraphTraversalSource t = g.traversal().withComputer(SparkGraphComputer.class);
        Assertions.assertEquals((long)1L, (long)((Long)t.V(new Object[0]).count().next()));
    }

    @Test
    public void testSchemaVerticesAreSkipped() throws Exception {
        this.mgmt.makePropertyKey("p").dataType(Integer.class).make();
        this.mgmt.makeVertexLabel("v").make();
        this.mgmt.makeEdgeLabel("e").make();
        this.finishSchema();
        hBaseContainer.createSnapshot("janusgraph-snapshot", "janusgraph");
        Graph g = this.getGraph();
        GraphTraversalSource t = g.traversal().withComputer(SparkGraphComputer.class);
        Assertions.assertEquals((long)0L, (long)((Long)t.V(new Object[0]).count().next()));
    }

    @Test
    public void testReadWithMetaProperties() throws Exception {
        GraphOfTheGodsFactory.load((JanusGraph)this.graph, null, (boolean)true);
        GraphTraversalSource t = this.graph.traversal();
        Assertions.assertEquals((long)0L, (long)((Long)t.V(new Object[0]).has("name", (Object)"sky").properties(new String[]{"property"}).count().next()));
        this.mgmt.makePropertyKey("prop").cardinality(Cardinality.SINGLE).dataType(String.class).make();
        this.mgmt.makePropertyKey("meta_property").cardinality(Cardinality.SINGLE).dataType(String.class).make();
        this.mgmt.commit();
        this.finishSchema();
        t.V(new Object[0]).has("name", (Object)"sky").property((Object)"prop", (Object)"value", new Object[0]).iterate();
        this.graph.tx().commit();
        Assertions.assertEquals((long)1L, (long)((Long)t.V(new Object[0]).has("name", (Object)"sky").properties(new String[]{"prop"}).count().next()));
        Assertions.assertEquals((long)0L, (long)((Long)t.V(new Object[0]).has("name", (Object)"sky").properties(new String[]{"prop"}).properties(new String[]{"meta_property"}).count().next()));
        t.V(new Object[0]).has("name", (Object)"sky").properties(new String[]{"prop"}).property((Object)"meta_property", (Object)"meta_value", new Object[0]).iterate();
        this.graph.tx().commit();
        Assertions.assertEquals((long)1L, (long)((Long)t.V(new Object[0]).has("name", (Object)"sky").properties(new String[]{"prop"}).properties(new String[]{"meta_property"}).count().next()));
        hBaseContainer.createSnapshot("janusgraph-snapshot", "janusgraph");
        Graph g = this.getGraph();
        t = g.traversal().withComputer(SparkGraphComputer.class);
        Assertions.assertEquals((long)1L, (long)((Long)t.V(new Object[0]).has("name", (Object)"sky").properties(new String[]{"prop"}).count().next()));
        Assertions.assertEquals((long)1L, (long)((Long)t.V(new Object[0]).has("name", (Object)"sky").properties(new String[]{"prop"}).properties(new String[]{"meta_property"}).count().next()));
    }

    protected Graph getGraph() throws IOException, ConfigurationException {
        PropertiesConfiguration config = ConfigurationUtil.loadPropertiesConfig((String)"target/test-classes/hbase-read-snapshot.properties", (boolean)false);
        Path baseOutDir = Paths.get((String)config.getProperty("gremlin.hadoop.outputLocation"), new String[0]);
        baseOutDir.toFile().mkdirs();
        String outDir = Files.createTempDirectory(baseOutDir, null, new FileAttribute[0]).toAbsolutePath().toString();
        config.setProperty("gremlin.hadoop.outputLocation", (Object)outDir);
        config.setProperty("janusgraphmr.ioformat.conf.storage.hbase.ext.hbase.rootdir", (Object)hBaseContainer.getHBaseRootDir().toString());
        return GraphFactory.open((Configuration)config);
    }

    public WriteConfiguration getConfiguration() {
        return hBaseContainer.getWriteConfiguration();
    }
}

