/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.config;

import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseAuthHelper {
    private static final Logger log = LoggerFactory.getLogger(HBaseAuthHelper.class);

    public static Configuration wrapConfiguration(Configuration inner) {
        String className = "org.apache.hadoop.hbase.HBaseConfiguration";
        String methodName = "create";
        Class<Configuration> methodArgType = Configuration.class;
        try {
            Class<?> clazz = HBaseAuthHelper.class.getClassLoader().loadClass("org.apache.hadoop.hbase.HBaseConfiguration");
            Method m = clazz.getMethod("create", methodArgType);
            return (Configuration)m.invoke(null, inner);
        }
        catch (Throwable t) {
            log.error("Failed to call {}.{}({})", new Object[]{"org.apache.hadoop.hbase.HBaseConfiguration", "create", methodArgType.getSimpleName(), t});
            return inner;
        }
    }

    public static void setHBaseAuthToken(Configuration configuration, Job job) {
        String hbaseAuthentication = configuration.get("hbase.security.authentication");
        if (null != hbaseAuthentication && hbaseAuthentication.equals("kerberos")) {
            String quorumCfgKey = "hbase.zookeeper.quorum";
            log.info("Obtaining HBase Auth Token from ZooKeeper quorum " + configuration.get(quorumCfgKey));
            String className = "org.apache.hadoop.hbase.security.User";
            try {
                Class<?> clazz = HBaseAuthHelper.class.getClassLoader().loadClass("org.apache.hadoop.hbase.security.User");
                Method getCurrent = clazz.getMethod("getCurrent", new Class[0]);
                Object user = getCurrent.invoke(null, new Object[0]);
                Method obtainAuthTokenForJob = clazz.getMethod("obtainAuthTokenForJob", Configuration.class, Job.class);
                obtainAuthTokenForJob.invoke(user, configuration, job);
                log.info("Obtained HBase Auth Token from ZooKeeper quorum {} for job {}", (Object)configuration.get(quorumCfgKey), (Object)job.getJobName());
            }
            catch (Throwable t) {
                log.error("Failed to generate or store HBase auth token", t);
            }
        } else {
            log.info("Not obtaining HBase Auth Token for MapReduce job " + job.getJobName());
        }
    }
}

