/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.blueprints;

import java.io.IOException;
import java.net.ServerSocket;
import org.janusgraph.HBaseContainer;
import org.janusgraph.blueprints.AbstractJanusGraphProvider;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseGraphProvider
extends AbstractJanusGraphProvider {
    private static final Logger logger = LoggerFactory.getLogger(HBaseGraphProvider.class);
    public static final HBaseContainer HBASE_CONTAINER;

    private static void waitForBindablePort(int port) {
        boolean canBindPort = false;
        do {
            try (ServerSocket serverSocket = new ServerSocket(port);){
                Assertions.assertNotNull((Object)serverSocket);
                Assertions.assertEquals((int)serverSocket.getLocalPort(), (int)port);
                serverSocket.close();
                canBindPort = true;
            }
            catch (IOException e) {
                logger.warn("can't bind port", (Throwable)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e2) {
                    logger.warn("can't sleep", (Throwable)e2);
                }
            }
        } while (!canBindPort);
    }

    public ModifiableConfiguration getJanusGraphConfiguration(String graphName, Class<?> test, String testMethodName) {
        return HBASE_CONTAINER.getNamedConfiguration(graphName, "");
    }

    static {
        HBaseGraphProvider.waitForBindablePort(2181);
        HBaseGraphProvider.waitForBindablePort(16000);
        HBASE_CONTAINER = new HBaseContainer();
        HBASE_CONTAINER.start();
    }
}

