/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.hbase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Pair;
import org.janusgraph.HBaseContainer;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.KeyColumnValueStoreUtil;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.hbase.HBaseStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class HBaseStoreManagerMutationTest {
    @Container
    public static final HBaseContainer hBaseContainer = new HBaseContainer();

    @Test
    public void testKCVMutationToPuts() throws Exception {
        long colName;
        HashMap storeMutationMap = new HashMap();
        HashMap<StaticBuffer, KCVMutation> rowkeyMutationMap = new HashMap<StaticBuffer, KCVMutation>();
        ArrayList<Long> expectedColumnsWithTTL = new ArrayList<Long>();
        ArrayList<Long> expectedColumnsWithoutTTL = new ArrayList<Long>();
        ArrayList<Long> expectedColumnDelete = new ArrayList<Long>();
        StaticArrayEntry e = null;
        for (int row = 0; row < 2; ++row) {
            int i;
            StaticBuffer rowkey = KeyColumnValueStoreUtil.longToByteBuffer((long)row);
            ArrayList<StaticArrayEntry> additions = new ArrayList<StaticArrayEntry>();
            ArrayList<StaticArrayEntry> deletions = new ArrayList<StaticArrayEntry>();
            for (i = 0; i < 100; ++i) {
                StaticBuffer col = KeyColumnValueStoreUtil.longToByteBuffer((long)i);
                StaticBuffer val = KeyColumnValueStoreUtil.longToByteBuffer((long)(i + 100));
                e = (StaticArrayEntry)StaticArrayEntry.of((StaticBuffer)col, (StaticBuffer)val);
                if (i % 2 == 0) {
                    e.setMetaData(EntryMetaData.TTL, (Object)(i % 10 + 1));
                    if (row == 1) {
                        expectedColumnsWithTTL.add(Long.valueOf(i));
                    }
                    additions.add(e);
                    continue;
                }
                if (row == 1) {
                    expectedColumnsWithoutTTL.add(Long.valueOf(i));
                }
                additions.add(e);
            }
            if (row == 1) {
                expectedColumnDelete.add(Long.valueOf(i - 1));
            }
            deletions.add(e);
            rowkeyMutationMap.put(rowkey, new KCVMutation(additions, deletions));
        }
        storeMutationMap.put("store1", rowkeyMutationMap);
        HBaseStoreManager manager = new HBaseStoreManager((Configuration)hBaseContainer.getModifiableConfiguration());
        Map commandsPerRowKey = manager.convertToCommands(storeMutationMap, Long.valueOf(0L), Long.valueOf(0L));
        Assertions.assertEquals((int)commandsPerRowKey.size(), (int)2);
        ArrayList<Long> putColumnsWithTTL = new ArrayList<Long>();
        ArrayList<Long> putColumnsWithoutTTL = new ArrayList<Long>();
        Pair commands = (Pair)commandsPerRowKey.values().iterator().next();
        for (Put p : (List)commands.getFirst()) {
            for (Map.Entry me : p.getFamilyCellMap().entrySet()) {
                for (Cell c : (List)me.getValue()) {
                    colName = KeyColumnValueStoreUtil.bufferToLong((StaticBuffer)new StaticArrayBuffer(CellUtil.cloneQualifier((Cell)c)));
                    if (p.getTTL() < Long.MAX_VALUE) {
                        putColumnsWithTTL.add(colName);
                        continue;
                    }
                    putColumnsWithoutTTL.add(colName);
                }
            }
        }
        Collections.sort(putColumnsWithoutTTL);
        Collections.sort(putColumnsWithTTL);
        Assertions.assertArrayEquals((Object[])expectedColumnsWithoutTTL.toArray(), (Object[])putColumnsWithoutTTL.toArray());
        Assertions.assertArrayEquals((Object[])expectedColumnsWithTTL.toArray(), (Object[])putColumnsWithTTL.toArray());
        ArrayList<Long> deleteColumns = new ArrayList<Long>();
        Delete d = (Delete)commands.getSecond();
        for (Map.Entry me : d.getFamilyCellMap().entrySet()) {
            for (Cell c : (List)me.getValue()) {
                colName = KeyColumnValueStoreUtil.bufferToLong((StaticBuffer)new StaticArrayBuffer(CellUtil.cloneQualifier((Cell)c)));
                deleteColumns.add(colName);
            }
        }
        Collections.sort(deleteColumns);
        Assertions.assertArrayEquals((Object[])expectedColumnDelete.toArray(), (Object[])deleteColumns.toArray());
    }

    @Test
    public void testMutationToPutsTTL() throws Exception {
        HashMap storeMutationMap = new HashMap();
        HashMap<StaticBuffer, KCVMutation> rowkeyMutationMap = new HashMap<StaticBuffer, KCVMutation>();
        ArrayList<Long> expectedColumnsWithTTL = new ArrayList<Long>();
        ArrayList<Long> putColumnsWithTTL = new ArrayList<Long>();
        ArrayList<StaticArrayEntry> additions = new ArrayList<StaticArrayEntry>();
        ArrayList<StaticArrayEntry> deletions = new ArrayList<StaticArrayEntry>();
        StaticBuffer rowkey = KeyColumnValueStoreUtil.longToByteBuffer((long)0L);
        StaticBuffer col = KeyColumnValueStoreUtil.longToByteBuffer((long)1L);
        StaticBuffer val = KeyColumnValueStoreUtil.longToByteBuffer((long)2L);
        StaticArrayEntry e = (StaticArrayEntry)StaticArrayEntry.of((StaticBuffer)col, (StaticBuffer)val);
        e.setMetaData(EntryMetaData.TTL, (Object)2147484);
        Integer ttl = (Integer)e.getMetaData().get(EntryMetaData.TTL);
        expectedColumnsWithTTL.add(TimeUnit.SECONDS.toMillis(ttl.intValue()));
        additions.add(e);
        deletions.add(e);
        rowkeyMutationMap.put(rowkey, new KCVMutation(additions, deletions));
        storeMutationMap.put("store1", rowkeyMutationMap);
        HBaseStoreManager manager = new HBaseStoreManager((Configuration)hBaseContainer.getModifiableConfiguration());
        Map commandsPerRowKey = manager.convertToCommands(storeMutationMap, Long.valueOf(0L), Long.valueOf(0L));
        Pair commands = (Pair)commandsPerRowKey.values().iterator().next();
        Put put = (Put)((List)commands.getFirst()).get(0);
        putColumnsWithTTL.add(put.getTTL());
        Assertions.assertArrayEquals((Object[])expectedColumnsWithTTL.toArray(), (Object[])putColumnsWithTTL.toArray());
    }
}

