/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.TemporaryBackendException;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.hbase.AdminMask;
import org.janusgraph.diskstorage.hbase.ConnectionMask;
import org.janusgraph.diskstorage.hbase.HBaseCompat;
import org.janusgraph.diskstorage.hbase.HBaseCompatLoader;
import org.janusgraph.diskstorage.hbase.HBaseStoreManager;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.idassigner.placement.SimpleBulkPlacementStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.ImageFromDockerfile;

public class HBaseContainer
extends GenericContainer<HBaseContainer> {
    private static final Logger logger = LoggerFactory.getLogger(HBaseContainer.class);
    public static final String HBASE_TARGET_DIR = "test.hbase.targetdir";
    private static final String DEFAULT_VERSION = "2.2.7";
    private static final String DEFAULT_UID = "1000";
    private static final String DEFAULT_GID = "1000";
    private final HBaseCompat compat;

    private static String getVersion() {
        String property = System.getProperty("hbase.docker.version");
        if (StringUtils.isNotEmpty((CharSequence)property)) {
            return property;
        }
        return DEFAULT_VERSION;
    }

    private static String getUid() {
        String property = System.getProperty("hbase.docker.uid");
        if (StringUtils.isNotEmpty((CharSequence)property)) {
            return property;
        }
        return "1000";
    }

    private static String getGid() {
        String property = System.getProperty("hbase.docker.gid");
        if (StringUtils.isNotEmpty((CharSequence)property)) {
            return property;
        }
        return "1000";
    }

    private static String getTargetDir() {
        String property = System.getProperty(HBASE_TARGET_DIR);
        if (StringUtils.isNotEmpty((CharSequence)property)) {
            return property;
        }
        return Paths.get(System.getProperty("user.dir"), "target").toString();
    }

    public HBaseContainer() {
        this(false);
    }

    public HBaseContainer(boolean mountRoot) {
        super((Future)((ImageFromDockerfile)new ImageFromDockerfile().withFileFromPath(".", Paths.get("docker", new String[0]))).withBuildArg("HBASE_VERSION", HBaseContainer.getVersion()).withBuildArg("HBASE_UID", HBaseContainer.getUid()).withBuildArg("HBASE_GID", HBaseContainer.getGid()));
        this.addFixedExposedPort(2181, 2181);
        this.addFixedExposedPort(16000, 16000);
        this.addFixedExposedPort(16010, 16010);
        this.addFixedExposedPort(16020, 16020);
        this.addFixedExposedPort(16030, 16030);
        if (mountRoot) {
            try {
                Files.createDirectories(this.getHBaseRootdir(), new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.warn("failed to create folder", (Throwable)e);
                throw new JanusGraphException((Throwable)e);
            }
            this.addFileSystemBind(this.getHBaseRootdir().toString(), "/data/hbase", BindMode.READ_WRITE);
        }
        this.withCreateContainerCmdModifier(createContainerCmd -> createContainerCmd.withHostName("localhost"));
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Master has completed initialization.*", (int)1));
        this.compat = HBaseCompatLoader.getCompat(null);
    }

    public Path getHBaseRootdir() {
        return Paths.get(HBaseContainer.getTargetDir(), "hbase-root");
    }

    private ConnectionMask createConnectionMask() throws IOException {
        Configuration entries = HBaseConfiguration.create();
        entries.set("hbase.zookeeper.quorum", "localhost");
        return this.compat.createConnection(entries);
    }

    public synchronized void createSnapshot(String snapshotName, String table) throws BackendException {
        try (ConnectionMask hc = this.createConnectionMask();
             AdminMask admin = hc.getAdmin();){
            admin.snapshot(snapshotName, table);
        }
        catch (Exception e) {
            logger.warn("Create HBase snapshot failed", (Throwable)e);
            throw new TemporaryBackendException("Create HBase snapshot failed", (Throwable)e);
        }
    }

    public synchronized void deleteSnapshot(String snapshotName) throws IOException {
        try (ConnectionMask hc = this.createConnectionMask();
             AdminMask admin = hc.getAdmin();){
            admin.deleteSnapshot(snapshotName);
        }
    }

    public WriteConfiguration getWriteConfiguration() {
        return this.getModifiableConfiguration().getConfiguration();
    }

    public ModifiableConfiguration getModifiableConfiguration() {
        return this.getNamedConfiguration(null, null);
    }

    public ModifiableConfiguration getNamedConfiguration(String tableName, String graphName) {
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildGraphConfiguration();
        config.set(GraphDatabaseConfiguration.STORAGE_BACKEND, (Object)"hbase", new String[0]);
        if (StringUtils.isNotEmpty((CharSequence)tableName)) {
            config.set(HBaseStoreManager.HBASE_TABLE, (Object)tableName, new String[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)graphName)) {
            config.set(GraphDatabaseConfiguration.GRAPH_NAME, (Object)graphName, new String[0]);
        }
        config.set(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, (Object)HBaseStoreManager.PREFERRED_TIMESTAMPS, new String[0]);
        config.set(GraphDatabaseConfiguration.STORAGE_HOSTS, (Object)new String[]{"localhost"}, new String[0]);
        config.set(SimpleBulkPlacementStrategy.CONCURRENT_PARTITIONS, (Object)1, new String[0]);
        config.set(GraphDatabaseConfiguration.DROP_ON_CLEAR, (Object)false, new String[0]);
        return config;
    }
}

