/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.formats.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraph;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.keycolumnvalue.KCVSUtil;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.KeyIterator;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.cache.CacheTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.cache.KCVSCache;
import org.janusgraph.diskstorage.locking.consistentkey.ExpectedValueCheckingTransaction;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.diskstorage.util.RecordIterator;
import org.janusgraph.diskstorage.util.StandardBaseTransactionConfig;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.diskstorage.util.time.TimestampProviders;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.RelationReader;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.idmanagement.IDManager;
import org.janusgraph.graphdb.internal.JanusGraphSchemaCategory;
import org.janusgraph.graphdb.query.QueryUtil;
import org.janusgraph.graphdb.relations.RelationIdentifier;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;
import org.janusgraph.graphdb.types.TypeDefinitionMap;
import org.janusgraph.graphdb.types.TypeInspector;
import org.janusgraph.graphdb.types.system.BaseKey;
import org.janusgraph.graphdb.types.system.BaseLabel;
import org.janusgraph.graphdb.types.vertices.JanusGraphSchemaVertex;
import org.janusgraph.hadoop.config.JanusGraphHadoopConfiguration;
import org.janusgraph.hadoop.config.ModifiableHadoopConfiguration;
import org.janusgraph.hadoop.formats.util.HadoopInputFormat;
import org.janusgraph.hadoop.formats.util.HadoopRecordReader;
import org.janusgraph.hadoop.formats.util.JanusGraphVertexDeserializer;
import org.janusgraph.hadoop.formats.util.input.JanusGraphHadoopSetup;
import org.janusgraph.hadoop.formats.util.input.SystemTypeInspector;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopRecordReaderTest
extends JanusGraphBaseTest {
    private static final Random random = new Random();
    private static final Logger log = LoggerFactory.getLogger(HadoopRecordReaderTest.class);

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        super.setUp(testInfo);
    }

    private Map<Object, Set<String>> generateRandomGraph(int numV) {
        int i;
        this.mgmt.makePropertyKey("uid").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makeEdgeLabel("knows").multiplicity(Multiplicity.MULTI).make();
        this.mgmt.makePropertyKey("values").cardinality(Cardinality.LIST).dataType(Integer.class).make();
        this.mgmt.makePropertyKey("numvals").dataType(Integer.class).make();
        this.finishSchema();
        HashMap<Object, Set<String>> vertexOutEdgeMap = new HashMap<Object, Set<String>>();
        int numE = 0;
        JanusGraphVertex[] vs = new JanusGraphVertex[numV];
        for (i = 0; i < numV; ++i) {
            vs[i] = this.tx.addVertex(new Object[]{"uid", i + 1});
            int numberOfValues = random.nextInt(5) + 1;
            vs[i].property(VertexProperty.Cardinality.single, "numvals", (Object)numberOfValues, new Object[0]);
            for (int j = 0; j < numberOfValues; ++j) {
                vs[i].property("values", (Object)random.nextInt(100));
            }
        }
        for (i = 0; i < numV; ++i) {
            int edges = i + 1;
            JanusGraphVertex v = vs[i];
            int e = 0;
            HashSet<String> edgeIdSet = new HashSet<String>();
            for (int j = 0; j < edges; ++j) {
                JanusGraphVertex u = vs[random.nextInt(numV)];
                JanusGraphEdge edge = v.addEdge("knows", (Vertex)u, new Object[0]);
                edgeIdSet.add(edge.id().toString());
                ++numE;
                ++e;
            }
            vertexOutEdgeMap.put(v.id(), edgeIdSet);
        }
        this.newTx();
        Assertions.assertEquals((int)(numV * (numV + 1)), (int)(numE * 2));
        return vertexOutEdgeMap;
    }

    public WriteConfiguration getConfiguration() {
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildGraphConfiguration();
        config.set(GraphDatabaseConfiguration.STORAGE_BACKEND, (Object)"inmemory", new String[0]);
        config.set(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, (Object)TimestampProviders.NANO, new String[0]);
        return config.getConfiguration();
    }

    private KeyIterator getAllDataFromKCVStore() throws BackendException {
        KCVSCache kcvsCache = this.graph.getBackend().getEdgeStoreCache();
        StoreTransaction tx = this.graph.getBackend().getStoreManager().beginTransaction((BaseTransactionConfig)StandardBaseTransactionConfig.of((TimestampProvider)TimestampProviders.NANO));
        ExpectedValueCheckingTransaction expectedValueCheckingTransaction = new ExpectedValueCheckingTransaction(tx, tx, Duration.ofMillis(1000000L));
        CacheTransaction cacheTransaction = new CacheTransaction((StoreTransaction)expectedValueCheckingTransaction, (KeyColumnValueStoreManager)this.graph.getBackend().getStoreManager(), 64, 100, Duration.ofMillis(100L), false);
        SliceQuery sliceQuery = new SliceQuery(BufferUtil.zeroBuffer((int)1), BufferUtil.oneBuffer((int)4));
        KeyIterator iterator = KCVSUtil.getKeys((KeyColumnValueStore)kcvsCache, (SliceQuery)sliceQuery, (StoreFeatures)this.graph.getBackend().getStoreFeatures(), (int)8, (StoreTransaction)cacheTransaction);
        return iterator;
    }

    @Test
    public void checkEdgeID() throws BackendException, IOException, InterruptedException {
        WriteConfiguration writeConfiguration = this.getConfiguration();
        Configuration hadoopConfig = new Configuration();
        String prefix = ConfigElement.getPath((ConfigElement)JanusGraphHadoopConfiguration.GRAPH_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + ".";
        for (String k : writeConfiguration.getKeys("")) {
            hadoopConfig.set(prefix + k, writeConfiguration.get(k, Object.class).toString());
        }
        Map<Object, Set<String>> vertexEdgeMap = this.generateRandomGraph(100);
        int totalRefEdgeCnt = 0;
        Set<Object> keySet = vertexEdgeMap.keySet();
        for (Object key : keySet) {
            totalRefEdgeCnt += vertexEdgeMap.get(key).size();
        }
        KeyIterator iterator = this.getAllDataFromKCVStore();
        StandardJanusGraphTx graphTx = (StandardJanusGraphTx)this.graph.buildTransaction().readOnly().start();
        HadoopInputFormat.RefCountedCloseable refCounter = new HadoopInputFormat.RefCountedCloseable(conf -> new JanusGraphVertexDeserializer((JanusGraphHadoopSetup)new JanusGraphHadoopSetupInternal((Configuration)conf, this.graph, graphTx)));
        refCounter.setBuilderConfiguration(hadoopConfig);
        HadoopRecordReader recordReader = new HadoopRecordReader(refCounter, (RecordReader)new RecordReaderWithKeyIterator(iterator));
        TaskAttemptContextImpl job = new TaskAttemptContextImpl(hadoopConfig, new TaskAttemptID(UUID.randomUUID().toString(), 0, TaskType.MAP, 0, 0));
        recordReader.initialize(null, (TaskAttemptContext)job);
        int totalEdgeCnt = 0;
        while (recordReader.nextKeyValue()) {
            VertexWritable vertexWritable = recordReader.getCurrentValue();
            StarGraph.StarVertex vertex = vertexWritable.get();
            Assert.assertTrue((vertex != null ? 1 : 0) != 0);
            Iterator edges = vertex.edges(Direction.OUT, new String[0]);
            HashSet<String> edgeIdSet = new HashSet<String>();
            while (edges.hasNext()) {
                Edge edge = (Edge)edges.next();
                RelationIdentifier relationIdentifier = RelationIdentifier.parse((String)((String)edge.id()));
                edgeIdSet.add((String)edge.id());
                Assert.assertTrue((relationIdentifier.getRelationId() > 0L ? 1 : 0) != 0);
                Assert.assertTrue((relationIdentifier.getInVertexId() != null ? 1 : 0) != 0);
                Assert.assertTrue((relationIdentifier.getOutVertexId() != null ? 1 : 0) != 0);
                Assert.assertTrue((relationIdentifier.getTypeId() > 0L ? 1 : 0) != 0);
            }
            totalEdgeCnt += edgeIdSet.size();
            Set<String> refEdgeIdSet = vertexEdgeMap.get(vertex.id());
            Assertions.assertEquals(edgeIdSet, refEdgeIdSet);
        }
        Assertions.assertEquals((int)totalRefEdgeCnt, (int)totalEdgeCnt);
    }

    public class RecordReaderWithKeyIterator
    extends RecordReader<StaticBuffer, Iterable<Entry>> {
        private boolean initialized = false;
        private final KeyIterator keyIterator;

        public RecordReaderWithKeyIterator(KeyIterator keyIterator) {
            this.keyIterator = keyIterator;
        }

        public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) {
            this.initialized = true;
        }

        public boolean nextKeyValue() {
            if (this.initialized) {
                return this.keyIterator.hasNext();
            }
            return false;
        }

        public StaticBuffer getCurrentKey() {
            return (StaticBuffer)this.keyIterator.next();
        }

        public Iterable<Entry> getCurrentValue() {
            RecordIterator entryRecordIterator = this.keyIterator.getEntries();
            return new EntryIterable((RecordIterator<Entry>)entryRecordIterator);
        }

        public float getProgress() {
            return 0.0f;
        }

        public void close() throws IOException {
            this.keyIterator.close();
        }

        private class RepeatableIterator
        implements RecordIterator<Entry> {
            private List<Entry> cache = new ArrayList<Entry>();
            private int index = 0;

            public RepeatableIterator(RecordIterator<Entry> data) {
                while (data.hasNext()) {
                    this.cache.add((Entry)data.next());
                }
            }

            public void reset() {
                this.index = 0;
            }

            public void close() throws IOException {
            }

            public boolean hasNext() {
                return this.index < this.cache.size();
            }

            public Entry next() {
                return this.cache.get(this.index++);
            }
        }

        private class EntryIterable
        implements Iterable<Entry> {
            RepeatableIterator repeatibleIterator;

            public EntryIterable(RecordIterator<Entry> data) {
                this.repeatibleIterator = new RepeatableIterator(data);
            }

            @Override
            public Iterator<Entry> iterator() {
                this.repeatibleIterator.reset();
                return this.repeatibleIterator;
            }
        }
    }

    public class JanusGraphHadoopSetupInternal
    implements JanusGraphHadoopSetup {
        private final ModifiableHadoopConfiguration scanConf;
        private final StandardJanusGraph graph;
        private final StandardJanusGraphTx tx;

        public JanusGraphHadoopSetupInternal(Configuration config, StandardJanusGraph graph, StandardJanusGraphTx tx) {
            this.scanConf = ModifiableHadoopConfiguration.of((ConfigNamespace)JanusGraphHadoopConfiguration.MAPRED_NS, (Configuration)config);
            this.graph = graph;
            this.tx = tx;
        }

        public TypeInspector getTypeInspector() {
            for (JanusGraphSchemaCategory sc : JanusGraphSchemaCategory.values()) {
                for (JanusGraphVertex k : QueryUtil.getVertices((StandardJanusGraphTx)this.tx, (PropertyKey)BaseKey.SchemaCategory, (Object)sc)) {
                    assert (k instanceof JanusGraphSchemaVertex);
                    JanusGraphSchemaVertex s = (JanusGraphSchemaVertex)k;
                    if (sc.hasName()) {
                        String name = s.name();
                        Preconditions.checkNotNull((Object)name);
                    }
                    TypeDefinitionMap dm = s.getDefinition();
                    Preconditions.checkNotNull((Object)dm);
                    s.getRelated(TypeDefinitionCategory.TYPE_MODIFIER, Direction.OUT);
                    s.getRelated(TypeDefinitionCategory.TYPE_MODIFIER, Direction.IN);
                }
            }
            return this.tx;
        }

        public SystemTypeInspector getSystemTypeInspector() {
            return new SystemTypeInspector(){

                public boolean isSystemType(long typeId) {
                    return IDManager.isSystemRelationTypeId((Object)typeId);
                }

                public boolean isVertexExistsSystemType(long typeId) {
                    return typeId == BaseKey.VertexExists.longId();
                }

                public boolean isVertexLabelSystemType(long typeId) {
                    return typeId == BaseLabel.VertexLabelEdge.longId();
                }

                public boolean isTypeSystemType(long typeId) {
                    return typeId == BaseKey.SchemaCategory.longId() || typeId == BaseKey.SchemaDefinitionProperty.longId() || typeId == BaseKey.SchemaDefinitionDesc.longId() || typeId == BaseKey.SchemaName.longId() || typeId == BaseLabel.SchemaDefinitionEdge.longId();
                }
            };
        }

        public RelationReader getRelationReader() {
            return this.graph.getEdgeSerializer();
        }

        public IDManager getIDManager() {
            return this.graph.getIDManager();
        }

        public void close() {
            this.tx.rollback();
            this.graph.close();
        }

        public boolean getFilterPartitionedVertices() {
            return (Boolean)this.scanConf.get(JanusGraphHadoopConfiguration.FILTER_PARTITIONED_VERTICES, true, new String[0]);
        }
    }
}

