/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.janusgraph.hadoop.config.job.AbstractDistCacheConfigurer;
import org.janusgraph.hadoop.config.job.JobClasspathConfigurer;

public class DistCacheConfigurer
extends AbstractDistCacheConfigurer
implements JobClasspathConfigurer {
    public DistCacheConfigurer(String mapReduceJarFileName) {
        super(mapReduceJarFileName);
    }

    @Override
    public void configure(Job job) throws IOException {
        Configuration conf = job.getConfiguration();
        LocalFileSystem localFS = FileSystem.getLocal((Configuration)conf);
        FileSystem jobFS = FileSystem.get((Configuration)conf);
        for (Path p : this.getLocalPaths()) {
            Path stagedPath = this.uploadFileIfNecessary((FileSystem)localFS, p, jobFS);
            job.addFileToClassPath(stagedPath);
        }
        String mj = this.getMapredJar();
        if (null != mj) {
            job.setJar(mj);
        }
    }
}

