/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.formats.util;

import com.carrotsearch.hppc.cursors.LongObjectCursor;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraph;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.graphdb.database.RelationReader;
import org.janusgraph.graphdb.idmanagement.IDManager;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.relations.RelationCache;
import org.janusgraph.graphdb.relations.RelationIdentifier;
import org.janusgraph.graphdb.types.TypeInspector;
import org.janusgraph.hadoop.formats.util.input.JanusGraphHadoopSetup;
import org.janusgraph.hadoop.formats.util.input.SystemTypeInspector;
import org.janusgraph.util.IDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JanusGraphVertexDeserializer
implements AutoCloseable {
    private final JanusGraphHadoopSetup setup;
    private final TypeInspector typeManager;
    private final SystemTypeInspector systemTypes;
    private final IDManager idManager;
    private static final Logger log = LoggerFactory.getLogger(JanusGraphVertexDeserializer.class);

    public JanusGraphVertexDeserializer(JanusGraphHadoopSetup setup) {
        this.setup = setup;
        this.typeManager = setup.getTypeInspector();
        this.systemTypes = setup.getSystemTypeInspector();
        this.idManager = setup.getIDManager();
    }

    private boolean edgeExists(Vertex vertex, RelationType type, RelationCache possibleDuplicate) {
        Iterator it = vertex.edges(possibleDuplicate.direction, new String[]{type.name()});
        while (it.hasNext()) {
            Edge edge = (Edge)it.next();
            if (!edge.id().equals(possibleDuplicate.relationId)) continue;
            return true;
        }
        return false;
    }

    public Vertex readHadoopVertex(StaticBuffer key, Iterable<Entry> entries) {
        RelationCache relation;
        RelationReader relationReader;
        Long vertexId = this.idManager.getKeyID(key);
        IDUtils.checkId((Object)vertexId);
        if (this.idManager.isPartitionedVertex((Object)vertexId)) {
            Preconditions.checkState((boolean)this.setup.getFilterPartitionedVertices(), (String)"Read partitioned vertex (ID=%s), but partitioned vertex filtering is disabled.", (Object)vertexId);
            log.debug("Skipping partitioned vertex with ID {}", (Object)vertexId);
            return null;
        }
        StarGraph sg = StarGraph.open();
        Vertex sv = null;
        for (Entry data : entries) {
            relationReader = this.setup.getRelationReader();
            relation = relationReader.parseRelation(data, false, this.typeManager);
            if (this.systemTypes.isVertexLabelSystemType(relation.typeId)) {
                long vertexLabelId = ((Number)relation.getOtherVertexId()).longValue();
                VertexLabel vl = this.typeManager.getExistingVertexLabel(vertexLabelId);
                sv = this.getOrCreateVertex(vertexId, vl.name(), sg);
                continue;
            }
            if (!this.systemTypes.isTypeSystemType(relation.typeId)) continue;
            log.trace("Vertex {} is a system vertex", (Object)vertexId);
            return null;
        }
        if (null == sv) {
            sv = this.getOrCreateVertex(vertexId, null, sg);
        }
        Preconditions.checkNotNull(sv, (String)"Unable to determine vertex label for vertex with ID %s", (Object)vertexId);
        for (Entry data : entries) {
            try {
                StarGraph.StarEdge se;
                RelationType type;
                relationReader = this.setup.getRelationReader();
                relation = relationReader.parseRelation(data, false, this.typeManager);
                if (this.systemTypes.isSystemType(relation.typeId) || ((InternalRelationType)(type = this.typeManager.getExistingRelationType(relation.typeId))).isInvisibleType()) continue;
                if (type.isPropertyKey()) {
                    Object value = relation.getValue();
                    Preconditions.checkNotNull((Object)value);
                    VertexProperty.Cardinality card = this.getPropertyKeyCardinality(type.name());
                    VertexProperty vp = sv.property(card, type.name(), value, new Object[]{T.id, relation.relationId});
                    this.decodeProperties(relation, (Element)vp);
                    continue;
                }
                assert (type.isEdgeLabel());
                if (this.idManager.isPartitionedVertex(relation.getOtherVertexId())) {
                    Preconditions.checkState((boolean)this.setup.getFilterPartitionedVertices(), (String)"Read edge incident on a partitioned vertex, but partitioned vertex filtering is disabled.  Relation ID: %s.  This vertex ID: %s.  Other vertex ID: %s.  Edge label: %s.", (Object)relation.relationId, (Object)vertexId, (Object)relation.getOtherVertexId(), (Object)type.name());
                    log.debug("Skipping edge with ID {} incident on partitioned vertex with ID {} (and nonpartitioned vertex with ID {})", new Object[]{relation.relationId, relation.getOtherVertexId(), vertexId});
                    continue;
                }
                Vertex adjacentVertex = this.getOrCreateVertex(relation.getOtherVertexId(), null, sg);
                if (sv.equals(adjacentVertex) && this.edgeExists(sv, type, relation)) continue;
                Object inVertexId = null;
                Object outVertexId = null;
                if (relation.direction.equals((Object)Direction.IN)) {
                    inVertexId = sv.id();
                    outVertexId = adjacentVertex.id();
                } else if (relation.direction.equals((Object)Direction.OUT)) {
                    inVertexId = adjacentVertex.id();
                    outVertexId = sv.id();
                } else {
                    throw new RuntimeException("Direction.BOTH is not supported");
                }
                RelationIdentifier relationIdentifier = new RelationIdentifier(outVertexId, this.typeManager.getRelationType(type.name()).longId(), relation.relationId, inVertexId);
                if (relation.direction.equals((Object)Direction.IN)) {
                    se = (StarGraph.StarEdge)adjacentVertex.addEdge(type.name(), sv, new Object[]{T.id, relationIdentifier.toString()});
                } else if (relation.direction.equals((Object)Direction.OUT)) {
                    se = (StarGraph.StarEdge)sv.addEdge(type.name(), adjacentVertex, new Object[]{T.id, relationIdentifier.toString()});
                } else {
                    throw new RuntimeException("Direction.BOTH is not supported");
                }
                this.decodeProperties(relation, (Element)se);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return sv;
    }

    private void decodeProperties(RelationCache relation, Element element) {
        if (relation.hasProperties()) {
            for (LongObjectCursor next : relation) {
                assert (next.value != null);
                RelationType rt = this.typeManager.getExistingRelationType(next.key);
                if (rt.isPropertyKey()) {
                    element.property(rt.name(), next.value);
                    continue;
                }
                throw new RuntimeException("Metaedges are not supported");
            }
        }
    }

    private Vertex getOrCreateVertex(Object vertexId, String label, StarGraph sg) {
        Iterator it = sg.vertices(new Object[]{vertexId});
        Vertex sv = it.hasNext() ? (Vertex)it.next() : (null != label ? sg.addVertex(new Object[]{T.label, label, T.id, vertexId}) : sg.addVertex(new Object[]{T.id, vertexId}));
        return sv;
    }

    private VertexProperty.Cardinality getPropertyKeyCardinality(String name) {
        RelationType rt = this.typeManager.getRelationType(name);
        if (null == rt || !rt.isPropertyKey()) {
            return VertexProperty.Cardinality.single;
        }
        PropertyKey pk = this.typeManager.getExistingPropertyKey(rt.longId());
        switch (pk.cardinality()) {
            case SINGLE: {
                return VertexProperty.Cardinality.single;
            }
            case LIST: {
                return VertexProperty.Cardinality.list;
            }
            case SET: {
                return VertexProperty.Cardinality.set;
            }
        }
        throw new IllegalStateException("Unknown cardinality " + pk.cardinality());
    }

    @Override
    public void close() {
        this.setup.close();
    }
}

