/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.hadoop.MapReduceIndexManagement;

public class MapReduceRemoveIndexApp
extends Configured
implements Tool {
    private JanusGraph graph;
    private String indexName;
    private ScanMetrics metrics;

    public MapReduceRemoveIndexApp(JanusGraph graph, String indexName) {
        this.graph = graph;
        this.indexName = indexName;
    }

    public int run(String[] args) throws Exception {
        Configuration hadoopConf = this.getConf();
        MapReduceIndexManagement mr = new MapReduceIndexManagement(this.graph);
        JanusGraphManagement mgmt = this.graph.openManagement();
        this.metrics = (ScanMetrics)mr.updateIndex((Index)mgmt.getGraphIndex(this.indexName), SchemaAction.DISCARD_INDEX, hadoopConf).get();
        return 0;
    }

    public ScanMetrics getMetrics() {
        return this.metrics;
    }
}

