/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.scan;

import java.io.IOException;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.graphdb.olap.VertexJobConverter;
import org.janusgraph.graphdb.olap.VertexScanJob;
import org.janusgraph.hadoop.config.JanusGraphHadoopConfiguration;
import org.janusgraph.hadoop.config.ModifiableHadoopConfiguration;
import org.janusgraph.hadoop.scan.HadoopContextScanMetrics;
import org.janusgraph.hadoop.scan.HadoopScanMapper;

public class HadoopVertexScanMapper
extends HadoopScanMapper {
    private JanusGraph graph;

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        org.apache.hadoop.conf.Configuration hadoopConf = context.getConfiguration();
        ModifiableHadoopConfiguration scanConf = ModifiableHadoopConfiguration.of(JanusGraphHadoopConfiguration.MAPRED_NS, hadoopConf);
        VertexScanJob vertexScan = this.getVertexScanJob(scanConf);
        ModifiableConfiguration graphConf = HadoopVertexScanMapper.getJanusGraphConfiguration(context);
        this.graph = JanusGraphFactory.open((BasicConfiguration)graphConf);
        this.job = VertexJobConverter.convert((JanusGraph)this.graph, (VertexScanJob)vertexScan);
        this.metrics = new HadoopContextScanMetrics((TaskInputOutputContext)context);
        this.finishSetup(scanConf, (Configuration)graphConf);
    }

    private VertexScanJob getVertexScanJob(ModifiableHadoopConfiguration conf) {
        String jobClass = (String)conf.get(JanusGraphHadoopConfiguration.SCAN_JOB_CLASS, new String[0]);
        try {
            return (VertexScanJob)Class.forName(jobClass).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        super.cleanup(context);
        this.graph.close();
    }
}

