/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.config;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.hadoop.conf.Configuration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.util.time.Durations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopConfiguration
implements WriteConfiguration {
    private static final Logger log = LoggerFactory.getLogger(HadoopConfiguration.class);
    private final Configuration config;
    private final String prefix;

    public HadoopConfiguration(Configuration config) {
        this(config, null);
    }

    public HadoopConfiguration(Configuration config, String prefix) {
        this.config = config;
        this.prefix = prefix;
    }

    public <O> O get(String key, Class<O> dataType) {
        String internalKey = this.getInternalKey(key);
        if (null == this.config.get(internalKey)) {
            return null;
        }
        if (dataType.isArray()) {
            Preconditions.checkArgument((dataType.getComponentType() == String.class ? 1 : 0) != 0, (String)"Only string arrays are supported: %s", dataType);
            return (O)this.config.getStrings(internalKey);
        }
        if (Number.class.isAssignableFrom(dataType)) {
            String s = this.config.get(internalKey);
            return this.constructFromStringArgument(dataType, s);
        }
        if (dataType == String.class) {
            return (O)this.config.get(internalKey);
        }
        if (dataType == Boolean.class) {
            return (O)Boolean.valueOf(this.config.get(internalKey));
        }
        if (dataType.isEnum()) {
            O[] constants = dataType.getEnumConstants();
            Preconditions.checkState((null != constants && 0 < constants.length ? 1 : 0) != 0, (Object)"Zero-length or undefined enum");
            String estr = this.config.get(internalKey);
            for (O c : constants) {
                if (!c.toString().equals(estr)) continue;
                return c;
            }
            throw new IllegalArgumentException("No match for string \"" + estr + "\" in enum " + dataType);
        }
        if (dataType == Object.class) {
            return (O)this.config.get(internalKey);
        }
        if (Duration.class.isAssignableFrom(dataType)) {
            TemporalUnit unit;
            String s = this.config.get(internalKey);
            String[] comps = s.split("\\s");
            switch (comps.length) {
                case 1: {
                    unit = ChronoUnit.MILLIS;
                    break;
                }
                case 2: {
                    unit = Durations.parse((String)comps[1]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot parse time duration from: " + s);
                }
            }
            return (O)Duration.of(Long.parseLong(comps[0]), unit);
        }
        throw new IllegalArgumentException("Unsupported data type: " + dataType);
    }

    public Iterable<String> getKeys(String userPrefix) {
        return StreamSupport.stream(this.config.spliterator(), false).map(Map.Entry::getKey).filter(internalKey -> {
            String k = internalKey;
            if (null != this.prefix) {
                if (k.startsWith(this.prefix)) {
                    k = this.getUserKey(k);
                } else {
                    return false;
                }
            }
            return k.startsWith(userPrefix);
        }).map(internalKey -> {
            String userKey = this.getUserKey((String)internalKey);
            Preconditions.checkState((boolean)userKey.startsWith(userPrefix));
            return userKey;
        }).collect(Collectors.toList());
    }

    public void close() {
    }

    public <O> void set(String key, O value) {
        String internalKey = this.getInternalKey(key);
        Class<?> dataType = value.getClass();
        if (dataType.isArray()) {
            Preconditions.checkArgument((dataType.getComponentType() == String.class ? 1 : 0) != 0, (String)"Only string arrays are supported: %s", dataType);
            this.config.setStrings(internalKey, (String[])value);
        } else if (Number.class.isAssignableFrom(dataType)) {
            this.config.set(internalKey, value.toString());
        } else if (dataType == String.class) {
            this.config.set(internalKey, value.toString());
        } else if (dataType == Boolean.class) {
            this.config.setBoolean(internalKey, ((Boolean)value).booleanValue());
        } else if (dataType.isEnum()) {
            this.config.set(internalKey, value.toString());
        } else if (dataType == Object.class) {
            this.config.set(internalKey, value.toString());
        } else if (Duration.class.isAssignableFrom(dataType)) {
            String millis = String.valueOf(((Duration)value).toMillis());
            this.config.set(internalKey, millis);
        } else {
            throw new IllegalArgumentException("Unsupported data type: " + dataType);
        }
    }

    public void remove(String key) {
        this.config.unset(this.getInternalKey(key));
    }

    public WriteConfiguration copy() {
        return new HadoopConfiguration(new Configuration(this.config), this.prefix);
    }

    private <O> O constructFromStringArgument(Class<O> dataType, String arg) {
        try {
            Constructor<O> ctor = dataType.getConstructor(String.class);
            return ctor.newInstance(arg);
        }
        catch (Exception e) {
            log.error("Failed to parse configuration string \"{}\" into type {} due to the following reflection exception", new Object[]{arg, dataType, e});
            throw new RuntimeException(e);
        }
    }

    private String getInternalKey(String userKey) {
        return null == this.prefix ? userKey : this.prefix + userKey;
    }

    private String getUserKey(String internalKey) {
        String k = internalKey;
        if (null != this.prefix) {
            Preconditions.checkState((boolean)k.startsWith(this.prefix), (String)"key %s does not start with prefix %s", (Object)internalKey, (Object)this.prefix);
            Preconditions.checkState((internalKey.length() > this.prefix.length() ? 1 : 0) != 0);
            k = internalKey.substring(this.prefix.length());
        }
        return k;
    }
}

