/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.grpc.schema;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.List;
import org.janusgraph.graphdb.grpc.schema.GetEdgeLabelByNameRequest;
import org.janusgraph.graphdb.grpc.schema.GetEdgeLabelByNameResponse;
import org.janusgraph.graphdb.grpc.schema.GetEdgeLabelsRequest;
import org.janusgraph.graphdb.grpc.schema.GetEdgeLabelsResponse;
import org.janusgraph.graphdb.grpc.schema.GetVertexCompositeGraphIndexByNameRequest;
import org.janusgraph.graphdb.grpc.schema.GetVertexCompositeGraphIndexByNameResponse;
import org.janusgraph.graphdb.grpc.schema.GetVertexCompositeGraphIndicesRequest;
import org.janusgraph.graphdb.grpc.schema.GetVertexCompositeGraphIndicesResponse;
import org.janusgraph.graphdb.grpc.schema.GetVertexLabelByNameRequest;
import org.janusgraph.graphdb.grpc.schema.GetVertexLabelByNameResponse;
import org.janusgraph.graphdb.grpc.schema.GetVertexLabelsRequest;
import org.janusgraph.graphdb.grpc.schema.GetVertexLabelsResponse;
import org.janusgraph.graphdb.grpc.schema.SchemaManagerServiceGrpc;
import org.janusgraph.graphdb.grpc.types.EdgeLabel;
import org.janusgraph.graphdb.grpc.types.JanusGraphContext;
import org.janusgraph.graphdb.grpc.types.VertexCompositeGraphIndex;
import org.janusgraph.graphdb.grpc.types.VertexLabel;

public class SchemaManagerClient {
    private final SchemaManagerServiceGrpc.SchemaManagerServiceBlockingStub blockingStub;
    private final JanusGraphContext context;

    public SchemaManagerClient(JanusGraphContext context, Channel channel) {
        this.context = context;
        this.blockingStub = SchemaManagerServiceGrpc.newBlockingStub(channel);
    }

    public SchemaManagerClient(JanusGraphContext context, String target) {
        this.context = context;
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)target).usePlaintext().build();
        this.blockingStub = SchemaManagerServiceGrpc.newBlockingStub((Channel)channel);
    }

    public VertexLabel getVertexLabelByName(String name) {
        GetVertexLabelByNameRequest request = GetVertexLabelByNameRequest.newBuilder().setContext(this.context).setName(name).build();
        GetVertexLabelByNameResponse response = this.blockingStub.getVertexLabelByName(request);
        return response.getVertexLabel();
    }

    public List<VertexLabel> getVertexLabels() {
        GetVertexLabelsRequest request = GetVertexLabelsRequest.newBuilder().setContext(this.context).build();
        GetVertexLabelsResponse response = this.blockingStub.getVertexLabels(request);
        return response.getVertexLabelsList();
    }

    public VertexCompositeGraphIndex getVertexCompositeGraphIndexByName(String name) {
        GetVertexCompositeGraphIndexByNameRequest request = GetVertexCompositeGraphIndexByNameRequest.newBuilder().setContext(this.context).setName(name).build();
        GetVertexCompositeGraphIndexByNameResponse response = this.blockingStub.getVertexCompositeGraphIndexByName(request);
        return response.getIndex();
    }

    public List<VertexCompositeGraphIndex> getVertexCompositeGraphIndices() {
        GetVertexCompositeGraphIndicesRequest request = GetVertexCompositeGraphIndicesRequest.newBuilder().setContext(this.context).build();
        GetVertexCompositeGraphIndicesResponse response = this.blockingStub.getVertexCompositeGraphIndices(request);
        return response.getIndicesList();
    }

    public EdgeLabel getEdgeLabelByName(String name) {
        GetEdgeLabelByNameRequest request = GetEdgeLabelByNameRequest.newBuilder().setContext(this.context).setName(name).build();
        GetEdgeLabelByNameResponse response = this.blockingStub.getEdgeLabelByName(request);
        return response.getEdgeLabel();
    }

    public List<EdgeLabel> getEdgeLabels() {
        GetEdgeLabelsRequest request = GetEdgeLabelsRequest.newBuilder().setContext(this.context).build();
        GetEdgeLabelsResponse response = this.blockingStub.getEdgeLabels(request);
        return response.getEdgeLabelsList();
    }
}

